/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.item.data;

import com.google.common.primitives.Primitives;
import io.github.pronze.lib.screaminglib.item.data.ItemData;
import io.github.pronze.lib.screaminglib.utils.GsonUtils;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitItemDataPersistentContainer
implements ItemData {
    private static final List<Class<?>> BASE_TAGS = List.of(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, int[].class, byte[].class, long[].class);
    private final Plugin plugin;
    private final PersistentDataContainer dataContainer;

    public static boolean isWrapperType(Class<?> clazz) {
        return BASE_TAGS.contains(clazz);
    }

    @Override
    public Set<String> getKeys() {
        PersistentDataContainer container = this.dataContainer;
        return container.getKeys().stream().map(NamespacedKey::getKey).collect(Collectors.toSet());
    }

    @Override
    public <T> void set(String key, T data, Class<T> tClass) {
        if (!Primitives.isWrapperType(tClass)) {
            tClass = Primitives.wrap(tClass);
        }
        PersistentDataContainer container = this.dataContainer;
        NamespacedKey namespacedKey = new NamespacedKey(this.plugin, key);
        if (BukkitItemDataPersistentContainer.isWrapperType(tClass)) {
            if (data instanceof String) {
                String s = (String)data;
                container.set(namespacedKey, PersistentDataType.STRING, (Object)s);
                return;
            }
            if (data instanceof Byte) {
                Byte s = (Byte)data;
                container.set(namespacedKey, PersistentDataType.BYTE, (Object)s);
                return;
            }
            if (data instanceof Short) {
                Short s = (Short)data;
                container.set(namespacedKey, PersistentDataType.SHORT, (Object)s);
                return;
            }
            if (data instanceof Integer) {
                Integer s = (Integer)data;
                container.set(namespacedKey, PersistentDataType.INTEGER, (Object)s);
                return;
            }
            if (data instanceof Long) {
                Long s = (Long)data;
                container.set(namespacedKey, PersistentDataType.LONG, (Object)s);
                return;
            }
            if (data instanceof Float) {
                Float s = (Float)data;
                container.set(namespacedKey, PersistentDataType.FLOAT, (Object)s);
                return;
            }
            if (data instanceof Double) {
                Double s = (Double)data;
                container.set(namespacedKey, PersistentDataType.DOUBLE, (Object)s);
                return;
            }
            if (data instanceof byte[]) {
                byte[] s = (byte[])data;
                container.set(namespacedKey, PersistentDataType.BYTE_ARRAY, (Object)s);
                return;
            }
            if (data instanceof int[]) {
                int[] s = (int[])data;
                container.set(namespacedKey, PersistentDataType.INTEGER_ARRAY, (Object)s);
                return;
            }
            if (data instanceof long[]) {
                long[] s = (long[])data;
                container.set(namespacedKey, PersistentDataType.LONG_ARRAY, (Object)s);
                return;
            }
            throw new UnsupportedOperationException("This stuff is not supported!");
        }
        container.set(namespacedKey, new JsonPersistentDataType(tClass), data);
    }

    @Override
    @Nullable
    public <T> T get(String key, Class<T> tClass) {
        if (!Primitives.isWrapperType(tClass)) {
            tClass = Primitives.wrap(tClass);
        }
        PersistentDataContainer container = this.dataContainer;
        NamespacedKey namespacedKey = new NamespacedKey(this.plugin, key);
        if (BukkitItemDataPersistentContainer.isWrapperType(tClass)) {
            if (String.class.isAssignableFrom(tClass)) {
                return (T)container.get(namespacedKey, PersistentDataType.STRING);
            }
            if (Byte.class.isAssignableFrom(tClass)) {
                return (T)container.get(namespacedKey, PersistentDataType.BYTE);
            }
            if (Short.class.isAssignableFrom(tClass)) {
                return (T)container.get(namespacedKey, PersistentDataType.SHORT);
            }
            if (Integer.class.isAssignableFrom(tClass)) {
                return (T)container.get(namespacedKey, PersistentDataType.INTEGER);
            }
            if (Long.class.isAssignableFrom(tClass)) {
                return (T)container.get(namespacedKey, PersistentDataType.LONG);
            }
            if (Float.class.isAssignableFrom(tClass)) {
                return (T)container.get(namespacedKey, PersistentDataType.FLOAT);
            }
            if (Double.class.isAssignableFrom(tClass)) {
                return (T)container.get(namespacedKey, PersistentDataType.DOUBLE);
            }
            if (byte[].class.isAssignableFrom(tClass)) {
                return (T)container.get(namespacedKey, PersistentDataType.BYTE_ARRAY);
            }
            if (int[].class.isAssignableFrom(tClass)) {
                return (T)container.get(namespacedKey, PersistentDataType.INTEGER_ARRAY);
            }
            if (long[].class.isAssignableFrom(tClass)) {
                return (T)container.get(namespacedKey, PersistentDataType.LONG_ARRAY);
            }
            throw new UnsupportedOperationException("This stuff is not supported!");
        }
        return (T)container.get(namespacedKey, new JsonPersistentDataType(tClass));
    }

    @Override
    public <T> Optional<T> getOptional(String key, Class<T> tClass) {
        return Optional.ofNullable(this.get(key, tClass));
    }

    @Override
    public <T> T getOrDefault(String key, Class<T> tClass, Supplier<T> def) {
        return this.getOptional(key, tClass).orElse(def.get());
    }

    @Override
    public boolean contains(String key) {
        Optional<NamespacedKey> namespacedKey = this.dataContainer.getKeys().stream().filter(next -> next.getNamespace().equalsIgnoreCase(this.plugin.getName().toLowerCase(Locale.ROOT))).filter(next -> next.getKey().equalsIgnoreCase(key)).findAny();
        return namespacedKey.isPresent();
    }

    @Override
    public boolean isEmpty() {
        return this.dataContainer.isEmpty();
    }

    public BukkitItemDataPersistentContainer(Plugin plugin, PersistentDataContainer dataContainer) {
        this.plugin = plugin;
        this.dataContainer = dataContainer;
    }

    public PersistentDataContainer getDataContainer() {
        return this.dataContainer;
    }

    public static class JsonPersistentDataType<T>
    implements PersistentDataType<String, T> {
        private final Class<T> tClass;

        public JsonPersistentDataType(Class<T> tClass) {
            this.tClass = tClass;
        }

        @NotNull
        public Class<String> getPrimitiveType() {
            return String.class;
        }

        @NotNull
        public Class<T> getComplexType() {
            return this.tClass;
        }

        @NotNull
        public String toPrimitive(@NotNull T complex, @NotNull PersistentDataAdapterContext context) {
            return GsonUtils.gson().toJson(complex);
        }

        @NotNull
        public T fromPrimitive(@NotNull String primitive, @NotNull PersistentDataAdapterContext context) {
            return GsonUtils.gson().fromJson(primitive, this.tClass);
        }
    }
}

