/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.item.data;

import com.google.common.primitives.Primitives;
import io.github.pronze.lib.screaminglib.item.data.ItemData;
import io.github.pronze.lib.screaminglib.nms.accessors.ByteArrayTagAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.ByteTagAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.DoubleTagAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.FloatTagAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.IntArrayTagAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.IntTagAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.LongArrayTagAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.LongTagAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.ShortTagAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.StringTagAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.TagAccessor;
import io.github.pronze.lib.screaminglib.utils.GsonUtils;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class CraftBukkitItemData
implements ItemData {
    private final Map<String, Object> keyNBTMap;

    @Override
    public Set<String> getKeys() {
        return this.keyNBTMap.keySet();
    }

    @Override
    public <T> void set(String key, T data, Class<T> tClass) {
        if (!Primitives.isWrapperType(tClass)) {
            tClass = Primitives.wrap(tClass);
        }
        if (tClass == byte[].class) {
            this.keyNBTMap.put(key, Reflect.construct(ByteArrayTagAccessor.getConstructor0(), data));
        } else if (tClass == Byte.class) {
            this.keyNBTMap.put(key, ByteTagAccessor.getMethodValueOf1() != null ? Reflect.fastInvoke(ByteTagAccessor.getMethodValueOf1(), data) : Reflect.construct(ByteTagAccessor.getConstructor0(), data));
        } else if (tClass == Double.class) {
            this.keyNBTMap.put(key, DoubleTagAccessor.getMethodValueOf1() != null ? Reflect.fastInvoke(DoubleTagAccessor.getMethodValueOf1(), data) : Reflect.construct(DoubleTagAccessor.getConstructor0(), data));
        } else if (tClass == Float.class) {
            this.keyNBTMap.put(key, FloatTagAccessor.getMethodValueOf1() != null ? Reflect.fastInvoke(FloatTagAccessor.getMethodValueOf1(), data) : Reflect.construct(FloatTagAccessor.getConstructor0(), data));
        } else if (tClass == int[].class) {
            this.keyNBTMap.put(key, Reflect.construct(IntArrayTagAccessor.getConstructor0(), data));
        } else if (tClass == Integer.class) {
            this.keyNBTMap.put(key, IntTagAccessor.getMethodValueOf1() != null ? Reflect.fastInvoke(IntTagAccessor.getMethodValueOf1(), data) : Reflect.construct(IntTagAccessor.getConstructor0(), data));
        } else if (tClass == long[].class) {
            this.keyNBTMap.put(key, Reflect.construct(LongArrayTagAccessor.getConstructor0(), data));
        } else if (tClass == Long.class) {
            this.keyNBTMap.put(key, LongTagAccessor.getMethodValueOf1() != null ? Reflect.fastInvoke(LongTagAccessor.getMethodValueOf1(), data) : Reflect.construct(LongTagAccessor.getConstructor0(), data));
        } else if (tClass == Short.class) {
            this.keyNBTMap.put(key, ShortTagAccessor.getMethodValueOf1() != null ? Reflect.fastInvoke(ShortTagAccessor.getMethodValueOf1(), data) : Reflect.construct(ShortTagAccessor.getConstructor0(), data));
        } else if (tClass == String.class) {
            this.keyNBTMap.put(key, StringTagAccessor.getMethodValueOf1() != null ? Reflect.fastInvoke(StringTagAccessor.getMethodValueOf1(), data) : Reflect.construct(StringTagAccessor.getConstructor0(), data));
        } else {
            this.keyNBTMap.put(key, GsonUtils.gson().toJson(data));
        }
    }

    @Override
    @Nullable
    public <T> T get(String key, Class<T> tClass) {
        Object nbt;
        if (!Primitives.isWrapperType(tClass)) {
            tClass = Primitives.wrap(tClass);
        }
        if ((nbt = this.keyNBTMap.get(key)) == null) {
            return null;
        }
        if (ByteArrayTagAccessor.getType() == nbt.getClass() && tClass == byte[].class) {
            return (T)Reflect.fastInvoke(nbt, ByteArrayTagAccessor.getMethodGetAsByteArray1());
        }
        if (ByteTagAccessor.getType() == nbt.getClass() && tClass == Byte.class) {
            return (T)Reflect.fastInvoke(nbt, ByteTagAccessor.getMethodGetAsByte1());
        }
        if (DoubleTagAccessor.getType() == nbt.getClass() && tClass == Double.class) {
            return (T)Reflect.fastInvoke(nbt, DoubleTagAccessor.getMethodGetAsDouble1());
        }
        if (FloatTagAccessor.getType() == nbt.getClass() && tClass == Float.class) {
            return (T)Reflect.fastInvoke(nbt, FloatTagAccessor.getMethodGetAsFloat1());
        }
        if (IntArrayTagAccessor.getType() == nbt.getClass() && tClass == int[].class) {
            return (T)Reflect.fastInvoke(nbt, IntArrayTagAccessor.getMethodGetAsIntArray1());
        }
        if (IntTagAccessor.getType() == nbt.getClass() && tClass == Integer.class) {
            return (T)Reflect.fastInvoke(nbt, IntTagAccessor.getMethodGetAsInt1());
        }
        if (LongArrayTagAccessor.getType() == nbt.getClass() && tClass == long[].class) {
            return (T)Reflect.fastInvoke(nbt, LongArrayTagAccessor.getMethodGetAsLongArray1());
        }
        if (LongTagAccessor.getType() == nbt.getClass() && tClass == Long.class) {
            return (T)Reflect.fastInvoke(nbt, LongTagAccessor.getMethodGetAsLong1());
        }
        if (ShortTagAccessor.getType() == nbt.getClass() && tClass == Short.class) {
            return (T)Reflect.fastInvoke(nbt, ShortTagAccessor.getMethodGetAsShort1());
        }
        if (tClass == String.class) {
            return (T)Reflect.fastInvoke(nbt, TagAccessor.getMethodGetAsString1());
        }
        return GsonUtils.gson().fromJson(Reflect.fastInvoke(nbt, TagAccessor.getMethodGetAsString1()).toString(), tClass);
    }

    @Override
    public <T> Optional<T> getOptional(String key, Class<T> tClass) {
        return Optional.ofNullable(this.get(key, tClass));
    }

    @Override
    public <T> T getOrDefault(String key, Class<T> tClass, Supplier<T> def) {
        return this.getOptional(key, tClass).orElseGet(def);
    }

    @Override
    public boolean contains(String key) {
        return this.keyNBTMap.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.keyNBTMap.isEmpty();
    }

    public CraftBukkitItemData(Map<String, Object> keyNBTMap) {
        this.keyNBTMap = keyNBTMap;
    }

    public Map<String, Object> getKeyNBTMap() {
        return this.keyNBTMap;
    }
}

