/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.item.meta;

import io.github.pronze.lib.screaminglib.bukkit.item.meta.BukkitPotionHolder;
import io.github.pronze.lib.screaminglib.item.meta.PotionMapping;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.key.NamespacedMappingKey;
import java.util.Arrays;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

@Service
public class BukkitPotionMapping
extends PotionMapping {
    public BukkitPotionMapping() {
        this.potionConverter.registerP2W(PotionType.class, BukkitPotionHolder::new).registerP2W(PotionData.class, BukkitPotionHolder::new);
        Arrays.stream(PotionType.values()).forEach(potion -> {
            BukkitPotionHolder holder = new BukkitPotionHolder((PotionType)potion);
            this.mapping.put(NamespacedMappingKey.of(potion.name()), holder);
            this.values.add(holder);
            if (potion.isExtendable()) {
                BukkitPotionHolder holder2 = new BukkitPotionHolder(new PotionData(potion, true, false));
                this.mapping.put(NamespacedMappingKey.of("long_" + potion.name()), holder2);
                this.values.add(holder2);
            }
            if (potion.isUpgradeable()) {
                BukkitPotionHolder holder3 = new BukkitPotionHolder(new PotionData(potion, false, true));
                this.mapping.put(NamespacedMappingKey.of("strong_" + potion.name()), holder3);
                this.values.add(holder3);
            }
        });
    }
}

