/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.packet;

import io.github.pronze.lib.screaminglib.bukkit.packet.CraftBukkitPacketWriter;
import io.github.pronze.lib.screaminglib.bukkit.packet.listener.ServerboundInteractPacketListener;
import io.github.pronze.lib.screaminglib.bukkit.utils.nms.ClassStorage;
import io.github.pronze.lib.screaminglib.nms.accessors.ArmorStandAccessor;
import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.PacketMapper;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.logger.LoggerWrapper;
import io.github.pronze.lib.screaminglib.vanilla.packet.PacketIdMapping;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import org.bukkit.Bukkit;

@Service(dependsOn={ServerboundInteractPacketListener.class})
public class BukkitPacketMapper
extends PacketMapper {
    private final LoggerWrapper logger;

    @Override
    public void sendPacket0(PlayerWrapper player, AbstractPacket packet) {
        if (packet == null) {
            throw new UnsupportedOperationException("Packet cannot be null!");
        }
        if (player == null) {
            throw new UnsupportedOperationException("Player cannot be null!");
        }
        if (!player.isOnline()) {
            this.logger.trace("Ignoring packet!, not sending packet to offline player.");
            return;
        }
        try {
            CraftBukkitPacketWriter writer = new CraftBukkitPacketWriter(Unpooled.buffer());
            writer.writeVarInt(packet.getId());
            int i = writer.getBuffer().writerIndex();
            packet.write(writer);
            int j = writer.getBuffer().writerIndex() - i;
            if (j > 0x200000) {
                throw new IllegalArgumentException("Packet too big (is " + j + ", should be less than 2097152): " + packet);
            }
            Channel channel = player.getChannel();
            if (channel.isActive()) {
                Runnable task = () -> {
                    ChannelFuture future = channel.writeAndFlush((Object)writer.getBuffer());
                    future.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                };
                if (channel.eventLoop().inEventLoop()) {
                    task.run();
                } else {
                    channel.eventLoop().execute(task);
                }
            }
            writer.getAppendedPackets().forEach(extraPacket -> this.sendPacket0(player, (AbstractPacket)extraPacket));
        }
        catch (Throwable t) {
            Bukkit.getLogger().severe("An exception occurred sending packet of class: " + packet.getClass().getSimpleName() + " to player: " + player.getName());
            t.printStackTrace();
        }
    }

    @Override
    public int getId0(Class<? extends AbstractPacket> clazz) {
        return PacketIdMapping.getPacketId(clazz);
    }

    @Override
    public int getProtocolVersion0(PlayerWrapper player) {
        throw new UnsupportedOperationException("BukkitPacketMapper#getProtocolVersion0() not been implemented yet!");
    }

    @Override
    public int getArmorStandTypeId0() {
        return ClassStorage.getEntityTypeId("armor_stand", ArmorStandAccessor.getType());
    }

    public BukkitPacketMapper(LoggerWrapper logger) {
        this.logger = logger;
    }
}

