/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.packet;

import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.bukkit.utils.nms.ClassStorage;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.nms.accessors.BlockAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.FriendlyByteBufAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.ItemStackAccessor;
import io.github.pronze.lib.screaminglib.slot.EquipmentSlotHolder;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import io.github.pronze.lib.screaminglib.vanilla.packet.VanillaPacketWriter;
import io.netty.buffer.ByteBuf;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class CraftBukkitPacketWriter
extends VanillaPacketWriter {
    public CraftBukkitPacketWriter(ByteBuf buffer) {
        super(buffer);
    }

    @Override
    public int getEquipmentSlotId(EquipmentSlotHolder equipmentSlotHolder) {
        return equipmentSlotHolder.as(EquipmentSlot.class).ordinal();
    }

    @Override
    protected Object materialHolderToItem(ItemTypeHolder material) {
        return Reflect.getMethod(ClassStorage.CB.CraftMagicNumbers, "getItem", Material.class).invokeStatic(material.as(Material.class));
    }

    @Override
    protected Object blockDataToBlockState(BlockTypeHolder blockData) {
        if (Reflect.has("org.bukkit.block.data.BlockData")) {
            return Reflect.fastInvoke((Object)blockData.as(BlockData.class), "getState");
        }
        MaterialData materialData = blockData.as(MaterialData.class);
        return Reflect.getMethod(ClassStorage.CB.CraftMagicNumbers, "getBlock", Material.class).invokeStaticResulted(materialData.getItemType()).fastInvoke(BlockAccessor.getMethodFromLegacyData1(), materialData.getData());
    }

    @Override
    protected Object getMinecraftServerInstance() {
        return Reflect.fastInvoke((Object)Bukkit.getServer(), "getServer");
    }

    @Override
    public void writeNBTFromItem(Item item) {
        Object nmsStack = Reflect.fastInvoke(ClassStorage.stackAsNMS(item.as(ItemStack.class)), ItemStackAccessor.getMethodCopy1());
        Object friendlyByteBuf = Reflect.constructor(FriendlyByteBufAccessor.getType(), ByteBuf.class).construct(this.getBuffer());
        Object nbtTag = Reflect.fastInvoke(nmsStack, ItemStackAccessor.getMethodGetTag1());
        Reflect.fastInvoke(friendlyByteBuf, FriendlyByteBufAccessor.getMethodWriteNbt1(), nbtTag);
    }
}

