/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.particle;

import io.github.pronze.lib.kyori.adventure.util.RGBLike;
import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.bukkit.utils.nms.Version;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.particle.DustOptions;
import io.github.pronze.lib.screaminglib.particle.DustTransition;
import io.github.pronze.lib.screaminglib.particle.ParticleData;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public final class BukkitParticleConverter {
    public static Object convertParticleData(ParticleData data) {
        if (data instanceof BlockTypeHolder) {
            if (Version.isVersion(1, 13)) {
                return data.as(BlockData.class);
            }
            return data.as(MaterialData.class);
        }
        if (data instanceof ItemTypeHolder) {
            return data.as(ItemStack.class);
        }
        if (data instanceof Item) {
            return data.as(ItemStack.class);
        }
        if (data instanceof DustOptions) {
            return new Particle.DustOptions(BukkitParticleConverter.getBukkitColor(((DustOptions)data).color()), ((DustOptions)data).size());
        }
        if (data instanceof DustTransition) {
            return new Particle.DustTransition(BukkitParticleConverter.getBukkitColor(((DustTransition)data).fromColor()), BukkitParticleConverter.getBukkitColor(((DustTransition)data).toColor()), ((DustTransition)data).size());
        }
        return null;
    }

    public static Color getBukkitColor(RGBLike rgb) {
        return Color.fromRGB((int)rgb.red(), (int)rgb.green(), (int)rgb.blue());
    }

    private BukkitParticleConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

