/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.particle;

import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.particle.DustOptions;
import io.github.pronze.lib.screaminglib.particle.DustTransition;
import io.github.pronze.lib.screaminglib.particle.ParticleData;
import io.github.pronze.lib.screaminglib.particle.ParticleTypeHolder;
import io.github.pronze.lib.screaminglib.utils.BasicWrapper;
import java.util.Arrays;
import org.bukkit.Particle;

public class BukkitParticleTypeHolder
extends BasicWrapper<Particle>
implements ParticleTypeHolder {
    public BukkitParticleTypeHolder(Particle wrappedObject) {
        super(wrappedObject);
    }

    @Override
    public String platformName() {
        return ((Particle)this.wrappedObject).name();
    }

    @Override
    public Class<? extends ParticleData> expectedDataClass() {
        Class dataType = ((Particle)this.wrappedObject).getDataType();
        if (dataType != Void.class) {
            switch (dataType.getSimpleName()) {
                case "MaterialData": 
                case "BlockData": {
                    return BlockTypeHolder.class;
                }
                case "ItemStack": {
                    return Item.class;
                }
                case "DustOptions": {
                    return DustOptions.class;
                }
                case "DustTransition": {
                    return DustTransition.class;
                }
            }
        }
        return null;
    }

    @Override
    public boolean is(Object object) {
        if (object instanceof Particle || object instanceof ParticleTypeHolder) {
            return this.equals(object);
        }
        return this.equals(ParticleTypeHolder.ofOptional(object).orElse(null));
    }

    @Override
    public boolean is(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::is);
    }
}

