/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.placeholders;

import io.github.pronze.lib.screaminglib.bukkit.placeholders.hooks.Hook;
import io.github.pronze.lib.screaminglib.bukkit.placeholders.hooks.PlaceholderAPIHook;
import io.github.pronze.lib.screaminglib.bukkit.player.BukkitPlayerMapper;
import io.github.pronze.lib.screaminglib.placeholders.PlaceholderExpansion;
import io.github.pronze.lib.screaminglib.placeholders.PlaceholderManager;
import io.github.pronze.lib.screaminglib.sender.MultiPlatformOfflinePlayer;
import io.github.pronze.lib.screaminglib.utils.Controllable;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

@Service(dependsOn={BukkitPlayerMapper.class})
public class BukkitPlaceholderManager
extends PlaceholderManager {
    private final List<Hook> activeHooks = new LinkedList<Hook>();

    public static void init(Plugin plugin, Controllable controllable) {
        PlaceholderManager.init(() -> new BukkitPlaceholderManager(plugin, controllable));
    }

    public BukkitPlaceholderManager(Plugin plugin, Controllable controllable) {
        controllable.enable(() -> {
            if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                this.activeHooks.add(new PlaceholderAPIHook(plugin));
            }
        }).disable(this.activeHooks::clear);
    }

    @Override
    public void registerExpansion0(PlaceholderExpansion expansion) {
        this.activeHooks.forEach(hook -> hook.register(expansion));
    }

    @Override
    public String resolveString0(MultiPlatformOfflinePlayer player, String message) {
        for (Hook hook : this.activeHooks) {
            message = hook.resolveString(player, message);
        }
        return message;
    }
}

