/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.placeholders.hooks;

import io.github.pronze.lib.screaminglib.bukkit.placeholders.hooks.Hook;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.sender.MultiPlatformOfflinePlayer;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PlaceholderAPIHook
implements Hook {
    private final Plugin plugin;

    @Override
    public void register(io.github.pronze.lib.screaminglib.placeholders.PlaceholderExpansion expansion) {
        new GenericExpansion(this.plugin, expansion).register();
    }

    @Override
    public String resolveString(MultiPlatformOfflinePlayer player, String message) {
        return PlaceholderAPI.setPlaceholders((OfflinePlayer)player.as(OfflinePlayer.class), (String)message);
    }

    public PlaceholderAPIHook(Plugin plugin) {
        this.plugin = plugin;
    }

    public static class GenericExpansion
    extends PlaceholderExpansion {
        private final Plugin plugin;
        private final io.github.pronze.lib.screaminglib.placeholders.PlaceholderExpansion placeholderExpansion;

        @NotNull
        public String getIdentifier() {
            return this.placeholderExpansion.getIdentifier();
        }

        @NotNull
        public String getAuthor() {
            return String.join((CharSequence)", ", this.plugin.getDescription().getAuthors());
        }

        @NotNull
        public String getVersion() {
            return this.plugin.getDescription().getVersion();
        }

        public String onRequest(OfflinePlayer player, @NotNull String params) {
            return AdventureHelper.toLegacyNullableResult(this.placeholderExpansion.onRequest(PlayerMapper.wrapOfflinePlayer(player), params));
        }

        public String onPlaceholderRequest(Player player, @NotNull String params) {
            return this.onRequest((OfflinePlayer)player, params);
        }

        public String getPlugin() {
            return this.plugin.getName();
        }

        public GenericExpansion(Plugin plugin, io.github.pronze.lib.screaminglib.placeholders.PlaceholderExpansion placeholderExpansion) {
            this.plugin = plugin;
            this.placeholderExpansion = placeholderExpansion;
        }
    }
}

