/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.tasker;

import com.google.common.base.Preconditions;
import io.github.pronze.lib.screaminglib.tasker.TaskBuilderImpl;
import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.lib.screaminglib.tasker.TaskerTime;
import io.github.pronze.lib.screaminglib.tasker.initializer.AbstractTaskInitializer;
import io.github.pronze.lib.screaminglib.tasker.task.AbstractTaskerTask;
import io.github.pronze.lib.screaminglib.tasker.task.TaskState;
import io.github.pronze.lib.screaminglib.tasker.task.TaskerTask;
import io.github.pronze.lib.screaminglib.utils.Controllable;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

@Service
public class BukkitTaskInitializer
extends AbstractTaskInitializer {
    private final Plugin plugin;
    private final BukkitScheduler scheduler;

    public static void init(Controllable controllable, Plugin plugin) {
        Tasker.init(() -> new BukkitTaskInitializer(controllable, plugin));
    }

    public BukkitTaskInitializer(Controllable controllable, Plugin plugin) {
        super(controllable);
        this.plugin = plugin;
        this.scheduler = plugin.getServer().getScheduler();
    }

    @Override
    public TaskerTask start(TaskBuilderImpl builder) {
        Runnable runnable = builder.getRunnable();
        if (builder.isAsync() && !builder.isAfterOneTick() && builder.getRepeat() == 0L && builder.getDelay() == 0L) {
            return AbstractTaskerTask.of(builder.getTaskId(), this.scheduler.runTaskAsynchronously(this.plugin, runnable), builder.getStopEvent());
        }
        if (builder.isAfterOneTick()) {
            return AbstractTaskerTask.of(builder.getTaskId(), this.scheduler.runTask(this.plugin, runnable), builder.getStopEvent());
        }
        TaskerTime timeUnit = (TaskerTime)((Object)Preconditions.checkNotNull((Object)((Object)builder.getTimeUnit()), (Object)"TimeUnit cannot be null!"));
        if (builder.getDelay() > 0L && builder.getRepeat() <= 0L) {
            if (builder.isAsync()) {
                return AbstractTaskerTask.of(builder.getTaskId(), this.scheduler.runTaskLaterAsynchronously(this.plugin, runnable, timeUnit.getBukkitTime(builder.getDelay())), builder.getStopEvent());
            }
            return AbstractTaskerTask.of(builder.getTaskId(), this.scheduler.runTaskLater(this.plugin, runnable, timeUnit.getBukkitTime(builder.getDelay())), builder.getStopEvent());
        }
        if (builder.getRepeat() > 0L) {
            if (builder.isAsync()) {
                return AbstractTaskerTask.of(builder.getTaskId(), this.scheduler.runTaskTimerAsynchronously(this.plugin, runnable, timeUnit.getBukkitTime(builder.getDelay()), timeUnit.getBukkitTime(builder.getRepeat())), builder.getStopEvent());
            }
            return AbstractTaskerTask.of(builder.getTaskId(), this.scheduler.runTaskTimer(this.plugin, runnable, timeUnit.getBukkitTime(builder.getDelay()), timeUnit.getBukkitTime(builder.getRepeat())), builder.getStopEvent());
        }
        throw new UnsupportedOperationException("Unsupported Tasker state!");
    }

    @Override
    public TaskState getState(TaskerTask taskerTask) {
        BukkitTask task = (BukkitTask)taskerTask.getTaskObject();
        if (task.isCancelled()) {
            return TaskState.FINISHED;
        }
        return TaskState.RUNNING;
    }

    @Override
    public void cancel(TaskerTask task) {
        BukkitTask toCancel = (BukkitTask)task.getTaskObject();
        toCancel.cancel();
    }
}

