/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.utils.nms;

import com.google.common.base.Preconditions;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.serializer.craftbukkit.MinecraftComponentSerializer;
import io.github.pronze.lib.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import io.github.pronze.lib.screaminglib.nms.accessors.Component_i_SerializerAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.EntityAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.EntityTypeAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.GoalSelectorAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.LevelAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.MappedRegistryAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.RegistryAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.RotationsAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.ServerPlayerAccessor;
import io.github.pronze.lib.screaminglib.utils.math.Vector3Df;
import io.github.pronze.lib.screaminglib.utils.reflect.InvocationResult;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ClassStorage {
    public static final boolean NMS_BASED_SERVER = ClassStorage.safeGetClass("org.bukkit.craftbukkit.Main") != null;
    public static final String NMS_VERSION = ClassStorage.checkNMSVersion();

    private static String checkNMSVersion() {
        String nmsVersion = "nms_not_found";
        if (NMS_BASED_SERVER) {
            String packName = Bukkit.getServer().getClass().getPackage().getName();
            nmsVersion = packName.substring(packName.lastIndexOf(46) + 1);
        }
        return nmsVersion;
    }

    public static Class<?> safeGetClass(String ... clazz) {
        return Reflect.getClassSafe(Map.of("{obc}", "org.bukkit.craftbukkit." + NMS_VERSION), clazz);
    }

    public static Object getHandle(Object obj) {
        return Reflect.getMethod(obj, "getHandle", new Class[0]).invoke(new Object[0]);
    }

    public static Object getPlayerConnection(Player player) {
        return Reflect.getMethod((Object)player, "getHandle", new Class[0]).invokeResulted(new Object[0]).getField(ServerPlayerAccessor.getFieldConnection());
    }

    public static Object getMethodProfiler(World world) {
        return ClassStorage.getMethodProfiler(ClassStorage.getHandle(world));
    }

    public static Object getMethodProfiler(Object handler) {
        Object methodProfiler = Reflect.fastInvoke(handler, LevelAccessor.getMethodGetProfiler1());
        if (methodProfiler == null) {
            methodProfiler = Reflect.getField(handler, LevelAccessor.getFieldField_72984_F());
        }
        return methodProfiler;
    }

    public static Object obtainNewPathfinderSelector(Object handler) {
        try {
            Object world = Reflect.fastInvoke(handler, EntityAccessor.getMethodGetCommandSenderWorld1());
            try {
                return GoalSelectorAccessor.getConstructor0().newInstance(Reflect.fastInvoke(world, LevelAccessor.getMethodGetProfilerSupplier1()));
            }
            catch (Throwable ignored) {
                try {
                    return GoalSelectorAccessor.getConstructor0().newInstance(() -> ClassStorage.getMethodProfiler(world));
                }
                catch (Throwable ignore) {
                    return GoalSelectorAccessor.getType().getConstructors()[0].newInstance(ClassStorage.getMethodProfiler(world));
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static Object getVectorToNMS(Vector3Df vector3f) {
        try {
            return RotationsAccessor.getConstructor0().newInstance(Float.valueOf(vector3f.getX()), Float.valueOf(vector3f.getY()), Float.valueOf(vector3f.getZ()));
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static Vector3Df getVectorFromNMS(Object vector3f) {
        Preconditions.checkNotNull((Object)vector3f, (Object)"Vector is null!");
        try {
            return new Vector3Df(((Float)Reflect.fastInvoke(vector3f, RotationsAccessor.getMethodGetX1())).floatValue(), ((Float)Reflect.fastInvoke(vector3f, RotationsAccessor.getMethodGetY1())).floatValue(), ((Float)Reflect.fastInvoke(vector3f, RotationsAccessor.getMethodGetZ1())).floatValue());
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static Object asMinecraftComponent(Component component) {
        try {
            return MinecraftComponentSerializer.get().serialize(component);
        }
        catch (Exception ignored) {
            return Reflect.fastInvoke(Component_i_SerializerAccessor.getMethodM_130701_1(), GsonComponentSerializer.gson().serialize(component));
        }
    }

    public static Object stackAsNMS(ItemStack item) {
        Preconditions.checkNotNull((Object)item, (Object)"Item is null!");
        return Reflect.getMethod(CB.CraftItemStack, "asNMSCopy", ItemStack.class).invokeStatic(item);
    }

    public static Object getDataWatcher(Object handler) {
        Preconditions.checkNotNull((Object)handler, (Object)"Handler is null!");
        return Reflect.fastInvoke(handler, EntityAccessor.getMethodGetEntityData1());
    }

    public static int getEntityTypeId(String key, Class<?> clazz) {
        InvocationResult registry = Reflect.getFieldResulted(RegistryAccessor.getFieldENTITY_TYPE());
        if (registry.isPresent()) {
            Object optional = Reflect.fastInvoke(EntityTypeAccessor.getMethodByString1(), key);
            if (optional instanceof Optional) {
                return registry.fastInvokeResulted(RegistryAccessor.getMethodGetId1(), ((Optional)optional).orElse(null)).asOptional(Integer.class).orElse(0);
            }
            Object nullable = Reflect.fastInvoke(EntityTypeAccessor.getMethodFunc_200713_a1(), key);
            return registry.fastInvokeResulted(RegistryAccessor.getMethodGetId1(), nullable).asOptional(Integer.class).orElse(0);
        }
        if (EntityTypeAccessor.getFieldField_191308_b() != null) {
            return Reflect.getFieldResulted(EntityTypeAccessor.getFieldField_191308_b()).fastInvokeResulted(MappedRegistryAccessor.getMethodFunc_148757_b1(), clazz).asOptional(Integer.class).orElse(0);
        }
        return (Integer)Reflect.getFieldResulted(EntityTypeAccessor.getFieldField_75624_e()).as(Map.class).get(clazz);
    }

    public static final class CB {
        public static final Class<?> CraftItemStack = ClassStorage.safeGetClass("{obc}.inventory.CraftItemStack");
        public static final Class<?> CraftMagicNumbers = ClassStorage.safeGetClass("{obc}.util.CraftMagicNumbers");
        public static final Class<?> CraftVector = ClassStorage.safeGetClass("{obc}.util.CraftVector");
        public static final Class<?> CraftPersistentDataContainer = ClassStorage.safeGetClass("{obc}.persistence.CraftPersistentDataContainer");
        public static final Class<?> CraftCustomItemTagContainer = ClassStorage.safeGetClass("{obc}.inventory.tags.CraftCustomItemTagContainer");
        public static final Class<?> CraftMetaItem = ClassStorage.safeGetClass("{obc}.inventory.CraftMetaItem");
        public static final Class<?> CraftPersistentDataTypeRegistry = ClassStorage.safeGetClass("{obc}.persistence.CraftPersistentDataTypeRegistry");
        public static final Class<?> CraftCustomTagTypeRegistry = ClassStorage.safeGetClass("{obc}.inventory.CraftCustomTagTypeRegistry");
        public static final Class<?> CraftSound = ClassStorage.safeGetClass("{obc}.CraftSound");
        private static Class<?> CraftLegacy;

        public static Class<?> UNSAFE_EVIL_GET_OUT_getCraftLegacy() {
            if (CraftLegacy == null) {
                CraftLegacy = ClassStorage.safeGetClass("{obc}.legacy.CraftLegacy");
            }
            return CraftLegacy;
        }
    }
}

