/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.utils.nms.entity;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.serializer.craftbukkit.MinecraftComponentSerializer;
import io.github.pronze.lib.screaminglib.bukkit.utils.nms.ClassStorage;
import io.github.pronze.lib.screaminglib.bukkit.utils.nms.Version;
import io.github.pronze.lib.screaminglib.nms.accessors.ComponentAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.EntityAccessor;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.screaminglib.utils.math.Vector3D;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import java.lang.reflect.Method;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class EntityNMS {
    protected Object handler;

    public EntityNMS(Object handler) {
        this.handler = handler;
    }

    public EntityNMS(Entity entity) {
        this(ClassStorage.getHandle(entity));
    }

    public Location getLocation() {
        if (Version.isVersion(1, 16)) {
            float pitch;
            float yaw;
            double locX = (Double)Reflect.fastInvoke(this.handler, EntityAccessor.getMethodGetX1());
            double locY = (Double)Reflect.fastInvoke(this.handler, EntityAccessor.getMethodGetY1());
            double locZ = (Double)Reflect.fastInvoke(this.handler, EntityAccessor.getMethodGetZ1());
            if (Version.isVersion(1, 17)) {
                yaw = ((Float)Reflect.fastInvoke(this.handler, EntityAccessor.getMethodGetXRot1())).floatValue();
                pitch = ((Float)Reflect.fastInvoke(this.handler, EntityAccessor.getMethodGetYRot1())).floatValue();
            } else {
                yaw = ((Float)Reflect.getField(this.handler, EntityAccessor.getFieldField_70177_z())).floatValue();
                pitch = ((Float)Reflect.getField(this.handler, EntityAccessor.getFieldField_70125_A())).floatValue();
            }
            Object world = Reflect.fastInvoke(this.handler, EntityAccessor.getMethodGetCommandSenderWorld1());
            World craftWorld = (World)Reflect.getMethod(world, "getWorld", new Class[0]).invoke(new Object[0]);
            return new Location(craftWorld, locX, locY, locZ, yaw, pitch);
        }
        double locX = (Double)Reflect.getField(this.handler, EntityAccessor.getFieldField_70165_t());
        double locY = (Double)Reflect.getField(this.handler, EntityAccessor.getFieldField_70163_u());
        double locZ = (Double)Reflect.getField(this.handler, EntityAccessor.getFieldField_70161_v());
        float yaw = ((Float)Reflect.getField(this.handler, EntityAccessor.getFieldField_70177_z())).floatValue();
        float pitch = ((Float)Reflect.getField(this.handler, EntityAccessor.getFieldField_70125_A())).floatValue();
        Object world = Reflect.fastInvoke(this.handler, EntityAccessor.getMethodGetCommandSenderWorld1());
        World craftWorld = (World)Reflect.getMethod(world, "getWorld", new Class[0]).invoke(new Object[0]);
        return new Location(craftWorld, locX, locY, locZ, yaw, pitch);
    }

    public Object getEntityType() {
        return Reflect.fastInvoke(this.handler, EntityAccessor.getMethodGetType1());
    }

    public void setLocation(Location location) {
        World craftWorld = (World)Reflect.fastInvokeResulted(this.handler, EntityAccessor.getMethodGetCommandSenderWorld1()).fastInvoke("getWorld");
        if (!location.getWorld().equals(craftWorld)) {
            Reflect.setField(this.handler, EntityAccessor.getFieldField_70170_p(), ClassStorage.getHandle(location.getWorld()));
        }
        Reflect.fastInvoke(this.handler, EntityAccessor.getMethodAbsMoveTo1(), location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
    }

    public Object getHandler() {
        return this.handler;
    }

    public int getId() {
        return (Integer)Reflect.fastInvoke(this.handler, EntityAccessor.getMethodGetId1());
    }

    public void setId(int id) {
        Reflect.setField(this.handler, EntityAccessor.getFieldId(), (Object)id);
    }

    public Object getDataWatcher() {
        return Reflect.fastInvoke(this.handler, EntityAccessor.getMethodGetEntityData1());
    }

    public void setCustomName(Component name) {
        Method method = EntityAccessor.getMethodSetCustomName1();
        if (method != null) {
            try {
                Reflect.fastInvoke(method, MinecraftComponentSerializer.get().serialize(name));
            }
            catch (Exception ignored) {
                Reflect.fastInvoke(method, ClassStorage.asMinecraftComponent(name));
            }
        } else {
            Reflect.fastInvoke(this.handler, EntityAccessor.getMethodFunc_96094_a1(), AdventureHelper.toLegacy(name));
        }
    }

    public Component getCustomName() {
        Object textComponent = Reflect.fastInvoke(this.handler, EntityAccessor.getMethodGetCustomName1());
        Class<?> stored = ComponentAccessor.getType();
        if (stored == null) {
            return Component.empty();
        }
        if (stored.isInstance(textComponent)) {
            try {
                try {
                    return MinecraftComponentSerializer.get().deserialize(textComponent);
                }
                catch (Exception ignored) {
                    return AdventureHelper.toComponent((String)Reflect.fastInvoke(textComponent, ComponentAccessor.getMethodFunc_150254_d1()));
                }
            }
            catch (Throwable t) {
                throw new UnsupportedOperationException("Cannot deserialize " + textComponent.toString(), t);
            }
        }
        return Component.empty();
    }

    public void setCustomNameVisible(boolean visible) {
        Reflect.fastInvoke(this.handler, EntityAccessor.getMethodSetCustomNameVisible1(), visible);
    }

    public boolean isCustomNameVisible() {
        return (Boolean)Reflect.fastInvoke(this.handler, EntityAccessor.getMethodIsCustomNameVisible1());
    }

    public void setInvisible(boolean invisible) {
        Reflect.fastInvoke(this.handler, EntityAccessor.getMethodSetInvisible1(), invisible);
    }

    public boolean isInvisible() {
        return (Boolean)Reflect.fastInvoke(this.handler, EntityAccessor.getMethodIsInvisible1());
    }

    public void setGravity(boolean gravity) {
        Reflect.fastInvoke(this.handler, EntityAccessor.getMethodSetNoGravity1(), !gravity);
    }

    public boolean isGravity() {
        return (Boolean)Reflect.fastInvoke(this.handler, EntityAccessor.getMethodIsNoGravity1()) == false;
    }

    public boolean isOnGround() {
        Object onGround_field = Reflect.getField(this.handler, EntityAccessor.getFieldOnGround());
        if (onGround_field != null) {
            return (Boolean)onGround_field;
        }
        return (Boolean)Reflect.fastInvoke(this.handler, EntityAccessor.getMethodIsOnGround1());
    }

    public UUID getUniqueId() {
        return (UUID)Reflect.fastInvoke(this.handler, EntityAccessor.getMethodGetUUID1());
    }

    public Vector3D getVelocity() {
        if (Reflect.getField(this.handler, EntityAccessor.getFieldField_70159_w()) != null) {
            double motX = (Double)Reflect.getField(this.handler, EntityAccessor.getFieldField_70159_w());
            double motY = (Double)Reflect.getField(this.handler, EntityAccessor.getFieldField_70181_x());
            double motZ = (Double)Reflect.getField(this.handler, EntityAccessor.getFieldField_70179_y());
            return new Vector3D(motX, motY, motZ);
        }
        Object mot = Reflect.fastInvoke(this.handler, EntityAccessor.getMethodGetDeltaMovement1());
        Vector bukkitVector = (Vector)Reflect.getMethod(ClassStorage.CB.CraftVector, "toBukkit", new Class[0]).invokeStatic(mot);
        if (bukkitVector == null) {
            return new Vector3D(0.0, 0.0, 0.0);
        }
        return new Vector3D(bukkitVector.getX(), bukkitVector.getY(), bukkitVector.getZ());
    }
}

