/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.world;

import io.github.pronze.lib.configurate.objectmapping.ConfigSerializable;
import io.github.pronze.lib.kyori.adventure.audience.Audience;
import io.github.pronze.lib.screaminglib.Server;
import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockMapper;
import io.github.pronze.lib.screaminglib.bukkit.particle.BukkitParticleConverter;
import io.github.pronze.lib.screaminglib.entity.EntityBasic;
import io.github.pronze.lib.screaminglib.entity.EntityMapper;
import io.github.pronze.lib.screaminglib.particle.ParticleHolder;
import io.github.pronze.lib.screaminglib.utils.BasicWrapper;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.github.pronze.lib.screaminglib.world.WorldHolder;
import io.github.pronze.lib.screaminglib.world.chunk.ChunkHolder;
import io.github.pronze.lib.screaminglib.world.chunk.ChunkMapper;
import io.github.pronze.lib.screaminglib.world.difficulty.DifficultyHolder;
import io.github.pronze.lib.screaminglib.world.dimension.DimensionHolder;
import io.github.pronze.lib.screaminglib.world.gamerule.GameRuleHolder;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

@ConfigSerializable
public class BukkitWorldHolder
extends BasicWrapper<World>
implements WorldHolder {
    public BukkitWorldHolder(World wrappedObject) {
        super(wrappedObject);
    }

    @Override
    public UUID getUuid() {
        return ((World)this.wrappedObject).getUID();
    }

    @Override
    public String getName() {
        return ((World)this.wrappedObject).getName();
    }

    @Override
    public int getMinY() {
        if (Reflect.hasMethod(this.wrappedObject, "getMinHeight", new Class[0])) {
            return ((World)this.wrappedObject).getMinHeight();
        }
        return 0;
    }

    @Override
    public int getMaxY() {
        return ((World)this.wrappedObject).getMaxHeight();
    }

    @Override
    public DifficultyHolder getDifficulty() {
        return DifficultyHolder.of(((World)this.wrappedObject).getDifficulty());
    }

    @Override
    public DimensionHolder getDimension() {
        return DimensionHolder.of(((World)this.wrappedObject).getEnvironment());
    }

    @Override
    public Optional<ChunkHolder> getChunkAt(int x, int z) {
        return ChunkMapper.wrapChunk(((World)this.wrappedObject).getChunkAt(x, z));
    }

    @Override
    public Optional<ChunkHolder> getChunkAt(LocationHolder location) {
        return ChunkMapper.wrapChunk(((World)this.wrappedObject).getChunkAt(location.as(Location.class)));
    }

    @Override
    public List<EntityBasic> getEntities() {
        return ((World)this.wrappedObject).getEntities().stream().map(EntityMapper::wrapEntity).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public <T> T getGameRuleValue(GameRuleHolder holder) {
        if (Reflect.has("org.bukkit.GameRule")) {
            return (T)((World)this.wrappedObject).getGameRuleValue(holder.as(GameRule.class));
        }
        String val = ((World)this.wrappedObject).getGameRuleValue(holder.platformName());
        if (val == null) {
            return null;
        }
        try {
            return (T)Integer.valueOf(val);
        }
        catch (Throwable ignored) {
            if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("false")) {
                return (T)Boolean.valueOf(val);
            }
            return (T)val;
        }
    }

    @Override
    public <T> void setGameRuleValue(GameRuleHolder holder, T value) {
        if (Reflect.has("org.bukkit.GameRule")) {
            ((World)this.wrappedObject).setGameRule(holder.as(GameRule.class), value);
        } else {
            ((World)this.wrappedObject).setGameRuleValue(holder.platformName(), value.toString());
        }
    }

    @Override
    public long getTime() {
        return ((World)this.wrappedObject).getTime();
    }

    @Override
    public void setTime(long time) {
        ((World)this.wrappedObject).setTime(time);
    }

    @Override
    public void sendParticle(ParticleHolder particle, LocationHolder location) {
        ((World)this.wrappedObject).spawnParticle(particle.particleType().as(Particle.class), location.as(Location.class), particle.count(), particle.offset().getX(), particle.offset().getY(), particle.offset().getZ(), particle.particleData(), particle.specialData() != null ? BukkitParticleConverter.convertParticleData(particle.specialData()) : null, particle.longDistance());
    }

    @Override
    public boolean isSpawnKeptInMemory() {
        return ((World)this.wrappedObject).getKeepSpawnInMemory();
    }

    @Override
    public boolean isSpawningOfAnimalsAllowed() {
        return ((World)this.wrappedObject).getAllowAnimals();
    }

    @Override
    public boolean isSpawningOfMonstersAllowed() {
        return ((World)this.wrappedObject).getAllowMonsters();
    }

    @Override
    public BlockHolder getHighestBlockAt(int x, int z) {
        return BlockMapper.wrapBlock(((World)this.wrappedObject).getHighestBlockAt(x, z));
    }

    @Override
    public int getHighestYAt(int x, int z) {
        return ((World)this.wrappedObject).getHighestBlockYAt(x, z);
    }

    @Override
    @NotNull
    public Iterable<? extends Audience> audiences() {
        return Server.getConnectedPlayersFromWorld(this);
    }
}

