/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.world.chunk;

import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockMapper;
import io.github.pronze.lib.screaminglib.entity.EntityBasic;
import io.github.pronze.lib.screaminglib.entity.EntityMapper;
import io.github.pronze.lib.screaminglib.utils.BasicWrapper;
import io.github.pronze.lib.screaminglib.world.WorldHolder;
import io.github.pronze.lib.screaminglib.world.WorldMapper;
import io.github.pronze.lib.screaminglib.world.chunk.ChunkHolder;
import java.util.Arrays;
import java.util.Optional;
import org.bukkit.Chunk;
import org.jetbrains.annotations.Range;

public class BukkitChunkHolder
extends BasicWrapper<Chunk>
implements ChunkHolder {
    public BukkitChunkHolder(Chunk wrappedObject) {
        super(wrappedObject);
    }

    @Override
    public int getX() {
        return ((Chunk)this.wrappedObject).getX();
    }

    @Override
    public int getZ() {
        return ((Chunk)this.wrappedObject).getZ();
    }

    @Override
    public WorldHolder getWorld() {
        return WorldMapper.wrapWorld(((Chunk)this.wrappedObject).getWorld());
    }

    @Override
    public BlockHolder getBlock(@Range(from=0L, to=15L) int x, int y, @Range(from=0L, to=15L) int z) {
        return BlockMapper.wrapBlock(((Chunk)this.wrappedObject).getBlock(x, y, z));
    }

    @Override
    public EntityBasic[] getEntities() {
        return (EntityBasic[])Arrays.stream(((Chunk)this.wrappedObject).getEntities()).map(EntityMapper::wrapEntity).filter(Optional::isPresent).map(Optional::orElseThrow).toArray(EntityBasic[]::new);
    }

    @Override
    public boolean isLoaded() {
        return ((Chunk)this.wrappedObject).isLoaded();
    }

    @Override
    public boolean load() {
        return ((Chunk)this.wrappedObject).load();
    }

    @Override
    public boolean load(boolean generate) {
        return ((Chunk)this.wrappedObject).load(generate);
    }

    @Override
    public boolean unload() {
        return ((Chunk)this.wrappedObject).unload();
    }

    @Override
    public boolean unload(boolean save) {
        return ((Chunk)this.wrappedObject).unload(save);
    }
}

