/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.configurate;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.configurate.serialize.TypeSerializer;
import io.github.pronze.lib.screaminglib.Server;
import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.configurate.AbstractScreamingSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BlockTypeHolderSerializer
extends AbstractScreamingSerializer
implements TypeSerializer<BlockTypeHolder> {
    public static final BlockTypeHolderSerializer INSTANCE = new BlockTypeHolderSerializer();

    @Override
    public BlockTypeHolder deserialize(Type type, ConfigurationNode node) throws SerializationException {
        try {
            return BlockTypeHolder.of(type);
        }
        catch (Throwable t) {
            throw new SerializationException(t);
        }
    }

    @Override
    public void serialize(Type type, @Nullable BlockTypeHolder obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
            return;
        }
        if (Server.isVersion(1, 13)) {
            StringBuilder builder = new StringBuilder(obj.platformName());
            Map<String, String> data = obj.flatteningData();
            if (!data.isEmpty()) {
                builder.append('[');
                builder.append(data.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(",")));
                builder.append(']');
            }
            node.set(builder.toString());
        } else {
            node.set(obj.platformName() + ":" + obj.legacyData());
        }
    }
}

