/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.configurate;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.configurate.serialize.TypeSerializer;
import io.github.pronze.lib.screaminglib.configurate.AbstractScreamingSerializer;
import io.github.pronze.lib.screaminglib.item.meta.EnchantmentHolder;
import java.lang.reflect.Type;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EnchantmentHolderSerializer
extends AbstractScreamingSerializer
implements TypeSerializer<EnchantmentHolder> {
    public static final EnchantmentHolderSerializer INSTANCE = new EnchantmentHolderSerializer();

    @Override
    public EnchantmentHolder deserialize(Type type, ConfigurationNode node) throws SerializationException {
        try {
            if (node.isMap()) {
                String typeNode = node.node("type").getString();
                int levelNode = node.node("level").getInt(1);
                if (typeNode != null && !typeNode.isEmpty()) {
                    return EnchantmentHolder.of(typeNode).withLevel(levelNode);
                }
            }
            return EnchantmentHolder.of(node.getString());
        }
        catch (Throwable t) {
            throw new SerializationException(t);
        }
    }

    @Override
    public void serialize(Type type, @Nullable EnchantmentHolder obj, ConfigurationNode node) throws SerializationException {
        node.set(obj == null ? null : obj.platformName() + " " + obj.level());
    }
}

