/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.configurate;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.configurate.serialize.TypeSerializer;
import io.github.pronze.lib.screaminglib.configurate.AbstractScreamingSerializer;
import io.github.pronze.lib.screaminglib.item.meta.PotionEffectHolder;
import java.lang.reflect.Type;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PotionEffectHolderSerializer
extends AbstractScreamingSerializer
implements TypeSerializer<PotionEffectHolder> {
    private static final String EFFECT_KEY = "effect";
    private static final String DURATION_KEY = "duration";
    private static final String AMPLIFIER_KEY = "amplifier";
    private static final String AMBIENT_KEY = "ambient";
    private static final String PARTICLES_KEY = "particles";
    private static final String ICON_KEY = "icon";
    public static final PotionEffectHolderSerializer INSTANCE = new PotionEffectHolderSerializer();

    @Override
    public PotionEffectHolder deserialize(Type type, ConfigurationNode node) throws SerializationException {
        try {
            if (!node.isMap()) {
                return PotionEffectHolder.of(node.getString());
            }
            ConfigurationNode effectNode = node.node(EFFECT_KEY);
            ConfigurationNode durationNode = node.node(DURATION_KEY);
            ConfigurationNode amplifierNode = node.node(AMPLIFIER_KEY);
            ConfigurationNode ambientNode = node.node(AMBIENT_KEY);
            ConfigurationNode particlesNode = node.node(PARTICLES_KEY);
            ConfigurationNode iconNode = node.node(ICON_KEY);
            PotionEffectHolder holder = PotionEffectHolder.of(effectNode.getString());
            return holder.withDuration(durationNode.getInt(holder.duration())).withAmplifier(amplifierNode.getInt(holder.amplifier())).withAmbient(ambientNode.getBoolean(holder.ambient())).withParticles(particlesNode.getBoolean(node.node("has-particles").getBoolean(holder.particles()))).withIcon(iconNode.getBoolean(node.node("has-icon").getBoolean(holder.icon())));
        }
        catch (Throwable t) {
            throw new SerializationException(t);
        }
    }

    @Override
    public void serialize(Type type, @Nullable PotionEffectHolder obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
            return;
        }
        node.node(EFFECT_KEY).set(obj.platformName());
        node.node(DURATION_KEY).set(obj.duration());
        node.node(AMPLIFIER_KEY).set(obj.amplifier());
        node.node(AMBIENT_KEY).set(obj.ambient());
        node.node(PARTICLES_KEY).set(obj.particles());
        node.node(ICON_KEY).set(obj.icon());
    }
}

