/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.container.type;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.ComponentLike;
import io.github.pronze.lib.screaminglib.container.Container;
import io.github.pronze.lib.screaminglib.container.ContainerFactory;
import io.github.pronze.lib.screaminglib.container.type.InventoryTypeMapping;
import io.github.pronze.lib.screaminglib.utils.ComparableWrapper;
import io.github.pronze.lib.screaminglib.utils.RawValueHolder;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import java.util.List;
import java.util.Optional;

public interface InventoryTypeHolder
extends ComparableWrapper,
RawValueHolder {
    @Deprecated(forRemoval=true)
    default public String getPlatformName() {
        return this.platformName();
    }

    public String platformName();

    public int size();

    @Deprecated(forRemoval=true)
    default public int getSize() {
        return this.size();
    }

    default public <C extends Container> Optional<C> createContainer(ComponentLike name) {
        return this.createContainer(name.asComponent());
    }

    default public <C extends Container> Optional<C> createContainer(Component name) {
        return ContainerFactory.createContainer(this, name);
    }

    default public <C extends Container> Optional<C> createContainer() {
        return ContainerFactory.createContainer(this);
    }

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.INVENTORY_TYPE)
    public boolean is(Object var1);

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.INVENTORY_TYPE)
    public boolean is(Object ... var1);

    @CustomAutocompletion(value=CustomAutocompletion.Type.INVENTORY_TYPE)
    public static InventoryTypeHolder of(Object inventoryType) {
        return InventoryTypeHolder.ofOptional(inventoryType).orElseThrow();
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.INVENTORY_TYPE)
    public static Optional<InventoryTypeHolder> ofOptional(Object inventoryType) {
        if (inventoryType instanceof InventoryTypeHolder) {
            return Optional.of((InventoryTypeHolder)inventoryType);
        }
        return InventoryTypeMapping.resolve(inventoryType);
    }

    public static List<InventoryTypeHolder> all() {
        return InventoryTypeMapping.getValues();
    }
}

