/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.entity;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.ComponentLike;
import io.github.pronze.lib.kyori.adventure.util.RGBLike;
import io.github.pronze.lib.screaminglib.container.ContainerHolder;
import io.github.pronze.lib.screaminglib.entity.type.EntityTypeHolder;
import io.github.pronze.lib.screaminglib.utils.RawValueHolder;
import io.github.pronze.lib.screaminglib.utils.Wrapper;
import io.github.pronze.lib.screaminglib.utils.math.Vector3D;
import io.github.pronze.lib.screaminglib.utils.math.Vector3Df;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;

public interface EntityBasic
extends Wrapper,
RawValueHolder,
ContainerHolder {
    public EntityTypeHolder getEntityType();

    public LocationHolder getLocation();

    public Vector3D getVelocity();

    public void setVelocity(Vector3D var1);

    public double getHeight();

    public double getWidth();

    public boolean isOnGround();

    public boolean isInWater();

    public CompletableFuture<Boolean> teleport(LocationHolder var1);

    default public CompletableFuture<Void> teleport(LocationHolder location, Runnable callback) {
        return this.teleport(location, callback, false);
    }

    public CompletableFuture<Void> teleport(LocationHolder var1, Runnable var2, boolean var3);

    public boolean teleportSync(LocationHolder var1);

    public int getEntityId();

    public int getFireTicks();

    public int getMaxFireTicks();

    public void setFireTicks(int var1);

    public void remove();

    public boolean isDead();

    public boolean isPersistent();

    public void setPersistent(boolean var1);

    public List<EntityBasic> getPassengers();

    public boolean addPassenger(EntityBasic var1);

    public boolean removePassenger(EntityBasic var1);

    public boolean hasPassengers();

    public boolean ejectPassengers();

    public float getFallDistance();

    public void setFallDistance(float var1);

    public UUID getUniqueId();

    public int getTicksLived();

    public void setTicksLived(int var1);

    public boolean isInsideVehicle();

    public boolean leaveVehicle();

    public EntityBasic getVehicle();

    public void setCustomName(String var1);

    public void setCustomName(Component var1);

    default public void setCustomName(ComponentLike name) {
        this.setCustomName(name.asComponent());
    }

    @Nullable
    public Component getCustomName();

    public void setCustomNameVisible(boolean var1);

    public boolean isCustomNameVisible();

    public void setGlowing(boolean var1);

    public boolean isGlowing();

    public void setInvulnerable(boolean var1);

    public boolean isInvulnerable();

    public boolean isSilent();

    public void setSilent(boolean var1);

    public boolean hasGravity();

    public void setGravity(boolean var1);

    public int getPortalCooldown();

    public void setPortalCooldown(int var1);

    public boolean hasMetadata(String var1);

    public Object getMetadata(String var1);

    public int getIntMetadata(String var1);

    public boolean getBooleanMetadata(String var1);

    public byte getByteMetadata(String var1);

    public long getLongMetadata(String var1);

    public String getStringMetadata(String var1);

    public Component getComponentMetadata(String var1);

    public LocationHolder getLocationMetadata(String var1);

    public RGBLike getColorMetadata(String var1);

    public Vector3D getVectorMetadata(String var1);

    public Vector3Df getFloatVectorMetadata(String var1);

    public void setMetadata(String var1, Object var2);
}

