/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.entity;

import io.github.pronze.lib.screaminglib.attribute.AttributeHolder;
import io.github.pronze.lib.screaminglib.attribute.AttributeTypeHolder;
import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.entity.EntityBasic;
import io.github.pronze.lib.screaminglib.entity.ProjectileShooter;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.meta.PotionEffectHolder;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public interface EntityLiving
extends EntityBasic,
ProjectileShooter {
    public Optional<AttributeHolder> getAttribute(AttributeTypeHolder var1);

    public double getEyeHeight();

    public double getEyeHeight(boolean var1);

    public LocationHolder getEyeLocation();

    public BlockHolder getTargetBlock(Collection<BlockTypeHolder> var1, int var2);

    public Optional<BlockHolder> getTargetBlock(int var1);

    public int getRemainingAir();

    public void setRemainingAir(int var1);

    public int getMaximumAir();

    public void setMaximumAir(int var1);

    public int getArrowCooldown();

    public void setArrowCooldown(int var1);

    public int getArrowsInBody();

    public void setArrowsInBody(int var1);

    public int getMaximumNoDamageTicks();

    public void setMaximumNoDamageTicks(int var1);

    public double getLastDamage();

    public void setLastDamage(double var1);

    public int getNoDamageTicks();

    public void setNoDamageTicks(int var1);

    public Optional<EntityLiving> getHumanKiller();

    public boolean addPotionEffect(PotionEffectHolder var1);

    public boolean addPotionEffects(Collection<PotionEffectHolder> var1);

    public boolean hasPotionEffect(PotionEffectHolder var1);

    public void removePotionEffect(PotionEffectHolder var1);

    public List<PotionEffectHolder> getActivePotionEffects();

    public boolean getRemoveWhenFarAway();

    public void setRemoveWhenFarAway(boolean var1);

    public void setCanPickupItems(boolean var1);

    public boolean getCanPickupItems();

    public boolean isLeashed();

    public Optional<EntityBasic> getLeashHolder();

    public boolean setLeashHolder(EntityBasic var1);

    public boolean removeLeashHolder();

    public boolean isGliding();

    public void setGliding(boolean var1);

    public boolean isSwimming();

    public void setSwimming(boolean var1);

    public boolean isRiptiding();

    public boolean isSleeping();

    public void setAI(boolean var1);

    public boolean hasAI();

    public void attack(EntityBasic var1);

    public void swingMainHand();

    public void swingOffHand();

    public void setCollidable(boolean var1);

    public boolean isCollidable();

    public void setInvisible(boolean var1);

    public boolean isInvisible();

    public void damage(double var1);

    public void damage(double var1, EntityBasic var3);

    public double getAbsorptionAmount();

    public double getHealth();

    public void setAbsorptionAmount(double var1);

    public void setHealth(double var1);

    @Nullable
    public Item getHelmet();

    @Nullable
    public Item getChestplate();

    @Nullable
    public Item getLeggings();

    @Nullable
    public Item getBoots();

    public void setHelmet(@Nullable Item var1);

    public void setChestplate(@Nullable Item var1);

    public void setLeggings(@Nullable Item var1);

    public void setBoots(@Nullable Item var1);

    @Nullable
    public Item getItemInMainHand();

    public void setItemInMainHand(@Nullable Item var1);

    @Nullable
    public Item getItemInOffHand();

    public void setItemInOffHand(@Nullable Item var1);

    default public Optional<EntityLiving> getTarget() {
        return this.getTarget(3);
    }

    default public Optional<EntityLiving> getTarget(int radius) {
        for (EntityLiving e : this.getLocation().getNearbyEntitiesByClass(EntityLiving.class, radius)) {
            LocationHolder eye = this.getEyeLocation();
            double dot = e.getLocation().asVector().subtract(eye.asVector()).normalize().dot(eye.getFacingDirection());
            if (!(dot > 0.99)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }
}

