/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.entity.pose;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.screaminglib.configurate.EntityPoseHolderSerializer;
import io.github.pronze.lib.screaminglib.entity.pose.EntityPoseHolder;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.OfMethodAlternative;
import io.github.pronze.lib.screaminglib.utils.mapper.AbstractTypeMapper;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@AbstractService(pattern="^(?<basePackage>.+)\\.(?<subPackage>[^\\.]+\\.[^\\.]+)\\.(?<className>.+)$")
public abstract class EntityPoseMapping
extends AbstractTypeMapper<EntityPoseHolder> {
    private static EntityPoseMapping entityPoseMapping;
    protected final BidirectionalConverter<EntityPoseHolder> entityPoseConverter = BidirectionalConverter.build().registerP2W(EntityPoseHolder.class, d -> d).registerP2W(ConfigurationNode.class, node -> {
        try {
            return EntityPoseHolderSerializer.INSTANCE.deserialize((Type)((Object)EntityPoseHolder.class), (ConfigurationNode)node);
        }
        catch (SerializationException ex) {
            ex.printStackTrace();
            return null;
        }
    });

    @ApiStatus.Internal
    public EntityPoseMapping() {
        if (entityPoseMapping != null) {
            throw new UnsupportedOperationException("EntityPoseMapping is already initialized!");
        }
        entityPoseMapping = this;
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.ENTITY_POSE)
    @OfMethodAlternative(value=EntityPoseHolder.class, methodName="ofOptional")
    public static Optional<EntityPoseHolder> resolve(Object entityPose) {
        if (entityPoseMapping == null) {
            throw new UnsupportedOperationException("EntityPoseMapping is not initialized yet.");
        }
        if (entityPose == null) {
            return Optional.empty();
        }
        return EntityPoseMapping.entityPoseMapping.entityPoseConverter.convertOptional(entityPose).or(() -> entityPoseMapping.resolveFromMapping(entityPose));
    }

    @OfMethodAlternative(value=EntityPoseHolder.class, methodName="all")
    public static List<EntityPoseHolder> getValues() {
        if (entityPoseMapping == null) {
            throw new UnsupportedOperationException("EntityPoseMapping is not initialized yet.");
        }
        return Collections.unmodifiableList(EntityPoseMapping.entityPoseMapping.values);
    }
}

