/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.entity.type;

import io.github.pronze.lib.screaminglib.entity.EntityBasic;
import io.github.pronze.lib.screaminglib.entity.type.EntityTypeMapping;
import io.github.pronze.lib.screaminglib.utils.ComparableWrapper;
import io.github.pronze.lib.screaminglib.utils.RawValueHolder;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import java.util.List;
import java.util.Optional;

public interface EntityTypeHolder
extends ComparableWrapper,
RawValueHolder {
    @Deprecated(forRemoval=true)
    default public String getPlatformName() {
        return this.platformName();
    }

    public String platformName();

    public boolean isAlive();

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.ENTITY_TYPE)
    public boolean is(Object var1);

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.ENTITY_TYPE)
    public boolean is(Object ... var1);

    public <T extends EntityBasic> Optional<T> spawn(LocationHolder var1);

    @CustomAutocompletion(value=CustomAutocompletion.Type.ENTITY_TYPE)
    public static EntityTypeHolder of(Object entityType) {
        return EntityTypeHolder.ofOptional(entityType).orElseThrow();
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.ENTITY_TYPE)
    public static Optional<EntityTypeHolder> ofOptional(Object entityType) {
        if (entityType instanceof EntityTypeHolder) {
            return Optional.of((EntityTypeHolder)entityType);
        }
        return EntityTypeMapping.resolve(entityType);
    }

    public static List<EntityTypeHolder> all() {
        return EntityTypeMapping.getValues();
    }
}

