/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.event;

import io.github.pronze.lib.screaminglib.event.Cancellable;
import io.github.pronze.lib.screaminglib.event.EventPriority;
import io.github.pronze.lib.screaminglib.event.SEvent;
import io.github.pronze.lib.screaminglib.utils.ConsumerExecutor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class EventHandler<E extends SEvent> {
    private Consumer<E> consumer;
    private final EventPriority eventPriority;
    private final boolean ignoreCancelled;

    public static <E extends SEvent> EventHandler<E> of(Consumer<E> consumer) {
        return EventHandler.of(consumer, EventPriority.NORMAL, false);
    }

    public static <E extends SEvent> EventHandler<E> of(Consumer<E> consumer, EventPriority eventPriority) {
        return EventHandler.of(consumer, eventPriority, false);
    }

    public static <E extends SEvent> EventHandler<E> of(Consumer<E> consumer, boolean ignoreCancelled) {
        return EventHandler.of(consumer, EventPriority.NORMAL, ignoreCancelled);
    }

    public static <E extends SEvent> EventHandler<E> ofOneTime(Function<@NotNull EventHandler<E>, @NotNull Consumer<E>> function) {
        EventHandler<E> manager = EventHandler.of(EventPriority.NORMAL, false);
        manager.consumer = function.apply(manager);
        return manager;
    }

    public static <E extends SEvent> EventHandler<E> ofOneTime(Function<@NotNull EventHandler<E>, @NotNull Consumer<E>> function, EventPriority eventPriority) {
        EventHandler<E> manager = EventHandler.of(eventPriority, false);
        manager.consumer = function.apply(manager);
        return manager;
    }

    public static <E extends SEvent> EventHandler<E> ofOneTime(Function<@NotNull EventHandler<E>, @NotNull Consumer<E>> function, boolean ignoreCancelled) {
        EventHandler<E> manager = EventHandler.of(EventPriority.NORMAL, ignoreCancelled);
        manager.consumer = function.apply(manager);
        return manager;
    }

    public static <E extends SEvent> EventHandler<E> ofOneTime(Function<@NotNull EventHandler<E>, @NotNull Consumer<E>> function, EventPriority eventPriority, boolean ignoreCancelled) {
        EventHandler<E> manager = EventHandler.of(eventPriority, ignoreCancelled);
        manager.consumer = function.apply(manager);
        return manager;
    }

    public void fire(SEvent event) {
        try {
            if (this.ignoreCancelled && event instanceof Cancellable && ((Cancellable)((Object)event)).isCancelled()) {
                return;
            }
            ConsumerExecutor.execute(this.consumer, event);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Consumer<E> getConsumer() {
        return this.consumer;
    }

    public EventPriority getEventPriority() {
        return this.eventPriority;
    }

    public boolean isIgnoreCancelled() {
        return this.ignoreCancelled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventHandler)) {
            return false;
        }
        EventHandler other = (EventHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIgnoreCancelled() != other.isIgnoreCancelled()) {
            return false;
        }
        Consumer<E> this$consumer = this.getConsumer();
        Consumer<E> other$consumer = other.getConsumer();
        if (this$consumer == null ? other$consumer != null : !this$consumer.equals(other$consumer)) {
            return false;
        }
        EventPriority this$eventPriority = this.getEventPriority();
        EventPriority other$eventPriority = other.getEventPriority();
        return !(this$eventPriority == null ? other$eventPriority != null : !((Object)((Object)this$eventPriority)).equals((Object)other$eventPriority));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIgnoreCancelled() ? 79 : 97);
        Consumer<E> $consumer = this.getConsumer();
        result = result * 59 + ($consumer == null ? 43 : $consumer.hashCode());
        EventPriority $eventPriority = this.getEventPriority();
        result = result * 59 + ($eventPriority == null ? 43 : ((Object)((Object)$eventPriority)).hashCode());
        return result;
    }

    public String toString() {
        return "EventHandler(consumer=" + this.getConsumer() + ", eventPriority=" + this.getEventPriority() + ", ignoreCancelled=" + this.isIgnoreCancelled() + ")";
    }

    private EventHandler(EventPriority eventPriority, boolean ignoreCancelled) {
        this.eventPriority = eventPriority;
        this.ignoreCancelled = ignoreCancelled;
    }

    private static <E extends SEvent> EventHandler<E> of(EventPriority eventPriority, boolean ignoreCancelled) {
        return new EventHandler<E>(eventPriority, ignoreCancelled);
    }

    private EventHandler(Consumer<E> consumer, EventPriority eventPriority, boolean ignoreCancelled) {
        this.consumer = consumer;
        this.eventPriority = eventPriority;
        this.ignoreCancelled = ignoreCancelled;
    }

    public static <E extends SEvent> EventHandler<E> of(Consumer<E> consumer, EventPriority eventPriority, boolean ignoreCancelled) {
        return new EventHandler<E>(consumer, eventPriority, ignoreCancelled);
    }
}

