/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.event;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.github.pronze.lib.screaminglib.event.EventHandler;
import io.github.pronze.lib.screaminglib.event.EventPriority;
import io.github.pronze.lib.screaminglib.event.HandlerRegisteredEvent;
import io.github.pronze.lib.screaminglib.event.HandlerUnregisteredEvent;
import io.github.pronze.lib.screaminglib.event.SEvent;
import io.github.pronze.lib.screaminglib.utils.Controllable;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.executor.ExecutorProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

@AbstractService
public abstract class EventManager {
    private static ExecutorService executor;
    private static EventManager defaultEventManager;
    private final Multimap<Class<?>, EventHandler<? extends SEvent>> handlers = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private EventManager customManager;

    public EventManager(Controllable controllable) {
        controllable.enable(() -> {
            executor = ExecutorProvider.buildExecutor("SEventManager");
        }).preDisable(this::destroy);
    }

    public static void init(Supplier<EventManager> supplier) {
        if (defaultEventManager != null) {
            throw new UnsupportedOperationException("Default EventManager has been already initialized!");
        }
        defaultEventManager = supplier.get();
    }

    public static <K extends SEvent> K fire(K event) {
        return defaultEventManager.fireEvent(event);
    }

    public static <K extends SEvent> CompletableFuture<K> fireAsync(K event) {
        return defaultEventManager.fireEventAsync(event);
    }

    public static EventManager createChildManager() {
        return new EventManager(){

            @Override
            public boolean isServerThread() {
                return defaultEventManager.isServerThread();
            }
        };
    }

    public static boolean isDefaultInitialized() {
        return defaultEventManager != null;
    }

    public <T extends SEvent> EventHandler<T> register(Class<T> event, Consumer<T> consumer) {
        return this.register(event, EventHandler.of(consumer));
    }

    public <T extends SEvent> EventHandler<T> registerOneTime(Class<T> event, Function<T, Boolean> function) {
        return this.register(event, EventHandler.ofOneTime(handler -> e -> {
            if (((Boolean)function.apply(e)).booleanValue()) {
                this.unregister((EventHandler)handler);
            }
        }));
    }

    public <T extends SEvent> EventHandler<T> register(Class<T> event, Consumer<T> consumer, boolean ignoreCancelled) {
        return this.register(event, EventHandler.of(consumer, ignoreCancelled));
    }

    public <T extends SEvent> EventHandler<T> registerOneTime(Class<T> event, Function<T, Boolean> function, boolean ignoreCancelled) {
        return this.register(event, EventHandler.ofOneTime(handler -> e -> {
            if (((Boolean)function.apply(e)).booleanValue()) {
                this.unregister((EventHandler)handler);
            }
        }, ignoreCancelled));
    }

    public <T extends SEvent> EventHandler<T> register(Class<T> event, Consumer<T> consumer, EventPriority eventPriority) {
        return this.register(event, EventHandler.of(consumer, eventPriority));
    }

    public <T extends SEvent> EventHandler<T> registerOneTime(Class<T> event, Function<T, Boolean> function, EventPriority eventPriority, boolean ignoreCancelled) {
        return this.register(event, EventHandler.ofOneTime(handler -> e -> {
            if (((Boolean)function.apply(e)).booleanValue()) {
                this.unregister((EventHandler)handler);
            }
        }, eventPriority, ignoreCancelled));
    }

    public <T extends SEvent> EventHandler<T> register(Class<T> event, Consumer<T> consumer, EventPriority eventPriority, boolean ignoreCancelled) {
        return this.register(event, EventHandler.of(consumer, eventPriority, ignoreCancelled));
    }

    public <T extends SEvent> EventHandler<T> register(Class<T> event, EventHandler<T> handler) {
        this.handlers.put(event, handler);
        this.fireEvent(new HandlerRegisteredEvent(this, event, handler));
        return handler;
    }

    public <T extends SEvent> void unregister(EventHandler<T> handler) {
        List.copyOf(this.handlers.entries()).forEach(entry -> {
            if (handler == entry.getValue()) {
                this.fireEvent(new HandlerUnregisteredEvent(this, (Class)entry.getKey(), handler));
                this.handlers.remove(entry.getKey(), entry.getValue());
            }
        });
    }

    public <K extends SEvent> K fireEvent(@NotNull K event) {
        EventPriority.VALUES.forEach(priority -> this.fireEvent(event, (EventPriority)((Object)priority)));
        return event;
    }

    public <K extends SEvent> K fireEvent(@NotNull K event, @NotNull EventPriority eventPriority) {
        if (event.isAsync() && this.isServerThread()) {
            throw new UnsupportedOperationException("Async event cannot be fired sync!");
        }
        this.findEventHandlers(event, eventPriority).forEach(eventHandler -> eventHandler.fire(event));
        if (this.customManager != null) {
            this.customManager.fireEvent(event, eventPriority);
        } else if (this != defaultEventManager) {
            defaultEventManager.fireEvent(event, eventPriority);
        }
        return event;
    }

    public <K extends SEvent> CompletableFuture<K> fireEventAsync(@NotNull K event) {
        LinkedList futures = new LinkedList();
        EventPriority.VALUES.forEach(priority -> futures.add(this.fireEventAsync(event, (EventPriority)((Object)priority))));
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(ignored -> event);
    }

    public <K extends SEvent> CompletableFuture<K> fireEventAsync(@NotNull K event, @NotNull EventPriority eventPriority) {
        if (!event.isAsync()) {
            return CompletableFuture.completedFuture(this.fireEvent(event, eventPriority));
        }
        LinkedList futures = this.findEventHandlers(event, eventPriority).map(eventHandler -> {
            if (this.isServerThread()) {
                return CompletableFuture.runAsync(() -> eventHandler.fire(event), executor).exceptionally(ex -> {
                    throw new RuntimeException("Exception occurred while firing event!", (Throwable)ex);
                });
            }
            return CompletableFuture.completedFuture(this.fireEvent(event, eventPriority));
        }).collect(Collectors.toCollection(LinkedList::new));
        if (this.customManager != null) {
            futures.add(this.customManager.fireEventAsync(event, eventPriority).thenApply(ignored -> null));
        } else if (this != defaultEventManager) {
            futures.add(defaultEventManager.fireEventAsync(event, eventPriority).thenApply(ignored -> null));
        }
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(event);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(ignored -> event);
    }

    public void unregisterAll() {
        List.copyOf(this.handlers.values()).forEach(this::unregister);
    }

    public void drop() {
        this.handlers.clear();
    }

    public void setCustomManager(EventManager parent) {
        if (this != defaultEventManager) {
            this.customManager = parent;
        }
    }

    public boolean isRegistered(EventHandler<?> eventHandler) {
        return this.handlers.values().contains(eventHandler);
    }

    public void cloneEventManager(EventManager originalEventManager) {
        originalEventManager.handlers.entries().forEach(entry -> this.register((Class)entry.getKey(), (EventHandler)entry.getValue()));
    }

    public void destroy() {
        this.handlers.clear();
        if (this == defaultEventManager) {
            ExecutorProvider.destroyExecutor(executor);
        }
    }

    private <E extends SEvent> Stream<? extends EventHandler<? extends SEvent>> findEventHandlers(E event, EventPriority priority) {
        return this.handlers.entries().stream().filter(entry -> ((Class)entry.getKey()).isInstance(event)).map(Map.Entry::getValue).filter(eventHandler -> eventHandler.getEventPriority() == priority);
    }

    public abstract boolean isServerThread();

    public EventManager() {
    }

    public static EventManager getDefaultEventManager() {
        return defaultEventManager;
    }

    public EventManager getCustomManager() {
        return this.customManager;
    }
}

