/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.event.player;

import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.event.PlatformEventWrapper;
import io.github.pronze.lib.screaminglib.event.SCancellableEvent;
import io.github.pronze.lib.screaminglib.event.SEvent;
import io.github.pronze.lib.screaminglib.event.player.SPlayerEvent;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.item.ItemView;
import io.github.pronze.lib.screaminglib.slot.EquipmentSlotHolder;
import io.github.pronze.lib.screaminglib.utils.BlockFace;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SPlayerInteractEvent
extends SCancellableEvent,
SPlayerEvent,
PlatformEventWrapper {
    @Nullable
    public ItemView getItem();

    public Action getAction();

    @Nullable
    public BlockHolder getBlockClicked();

    public BlockFace getBlockFace();

    public SEvent.Result getUseClickedBlock();

    public void setUseClickedBlock(SEvent.Result var1);

    public SEvent.Result getUseItemInHand();

    public void setUseItemInHand(SEvent.Result var1);

    @Nullable
    public EquipmentSlotHolder getHand();

    @Override
    default public void setCancelled(boolean cancel) {
        this.setUseClickedBlock(cancel ? SEvent.Result.DENY : (this.getUseClickedBlock() == SEvent.Result.DENY ? SEvent.Result.DEFAULT : this.getUseClickedBlock()));
        this.setUseItemInHand(cancel ? SEvent.Result.DENY : (this.getUseItemInHand() == SEvent.Result.DENY ? SEvent.Result.DEFAULT : this.getUseItemInHand()));
    }

    default public boolean hasBlock() {
        return this.getBlockClicked() != null;
    }

    default public boolean hasItem() {
        return this.getItem() != null;
    }

    @NotNull
    default public ItemTypeHolder getMaterial() {
        if (!this.hasItem()) {
            return ItemTypeHolder.air();
        }
        return this.getItem().getMaterial();
    }

    @Override
    @Deprecated
    default public boolean isCancelled() {
        return this.getUseClickedBlock() == SEvent.Result.DENY;
    }

    public static enum Action {
        LEFT_CLICK_BLOCK,
        RIGHT_CLICK_BLOCK,
        LEFT_CLICK_AIR,
        RIGHT_CLICK_AIR,
        PHYSICAL;

        public static List<Action> VALUES;

        public static Action convert(String name) {
            return VALUES.stream().filter(next -> next.name().equalsIgnoreCase(name)).findFirst().orElse(LEFT_CLICK_AIR);
        }

        static {
            VALUES = Arrays.asList(Action.values());
        }
    }
}

