/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.healthindicator;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.ComponentLike;
import io.github.pronze.lib.screaminglib.entity.EntityHuman;
import io.github.pronze.lib.screaminglib.healthindicator.HealthIndicator;
import io.github.pronze.lib.screaminglib.healthindicator.HealthIndicatorManager;
import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetDisplayObjectivePacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetObjectivePacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetScorePacket;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.lib.screaminglib.tasker.TaskerTime;
import io.github.pronze.lib.screaminglib.tasker.task.TaskerTask;
import io.github.pronze.lib.screaminglib.utils.data.DataContainer;
import io.github.pronze.lib.screaminglib.visuals.impl.AbstractVisual;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;

public class HealthIndicatorImpl
extends AbstractVisual<HealthIndicator>
implements HealthIndicator {
    private final String underNameTagKey;
    private final String tabListKey;
    private final ConcurrentSkipListMap<String, Integer> values = new ConcurrentSkipListMap();
    protected final List<PlayerWrapper> trackedPlayers = new LinkedList<PlayerWrapper>();
    protected DataContainer data;
    protected volatile boolean ready;
    protected volatile boolean healthInTabList;
    protected volatile Component symbol = Component.empty();
    protected TaskerTask task;

    public HealthIndicatorImpl(UUID uuid) {
        super(uuid);
        this.underNameTagKey = HealthIndicatorImpl.generateObjectiveKey();
        this.tabListKey = HealthIndicatorImpl.generateObjectiveKey();
    }

    @Override
    public HealthIndicator addTrackedPlayer(PlayerWrapper player) {
        if (!this.trackedPlayers.contains(player)) {
            this.trackedPlayers.add(player);
            if (this.visible && this.ready && this.task == null) {
                this.update();
            }
        }
        return this;
    }

    @Override
    public HealthIndicator removeTrackedPlayer(PlayerWrapper player) {
        if (this.trackedPlayers.contains(player)) {
            this.trackedPlayers.remove(player);
            if (this.visible && this.ready && this.task == null) {
                this.update();
            }
        }
        return this;
    }

    @Override
    public HealthIndicator symbol(ComponentLike symbol) {
        return this.symbol(symbol.asComponent());
    }

    @Override
    public HealthIndicator showHealthInTabList(boolean flag) {
        this.healthInTabList = flag;
        return this;
    }

    @Override
    public HealthIndicator symbol(Component symbol) {
        this.symbol = symbol;
        if (this.visible && this.ready) {
            this.updateSymbol0();
        }
        return this;
    }

    @Override
    public boolean hasData() {
        if (this.data == null) {
            return false;
        }
        return !this.data.isEmpty();
    }

    @Override
    public HealthIndicator update() {
        if (this.ready) {
            this.update0();
        } else {
            this.viewers.forEach(viewer -> this.onViewerRemoved((PlayerWrapper)viewer, false));
        }
        return this;
    }

    @Override
    public HealthIndicator show() {
        this.ready = true;
        this.visible = true;
        this.viewers.forEach(a -> this.onViewerAdded((PlayerWrapper)a, false));
        this.update();
        return this;
    }

    @Override
    public HealthIndicator hide() {
        this.visible = false;
        this.ready = false;
        this.update();
        return this;
    }

    @Override
    public void destroy() {
        this.data = null;
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        this.hide();
        this.viewers.clear();
        this.trackedPlayers.clear();
        this.values.clear();
        HealthIndicatorManager.removeHealthIndicator(this);
    }

    @Override
    public HealthIndicator startUpdateTask(long time, TaskerTime unit) {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = Tasker.build(this::update).async().repeat(time, unit).start();
        return this;
    }

    protected void updateSymbol0() {
        if (this.visible) {
            this.getUpdateObjectivePacket().objectiveKey(this.underNameTagKey).sendPacket(this.viewers);
            if (this.healthInTabList) {
                this.getUpdateObjectivePacket().objectiveKey(this.tabListKey).sendPacket(this.viewers);
            }
        }
    }

    @Override
    public void onViewerAdded(PlayerWrapper player, boolean checkDistance) {
        if (this.visible) {
            this.getCreateObjectivePacket().objectiveKey(this.underNameTagKey).sendPacket(player);
            new SClientboundSetDisplayObjectivePacket().objectiveKey(this.underNameTagKey).slot(SClientboundSetDisplayObjectivePacket.DisplaySlot.BELOW_NAME).sendPacket(player);
            this.values.forEach((s, integer) -> this.createScorePacket((String)s, (int)integer).objectiveKey(this.underNameTagKey).sendPacket(player));
            if (this.healthInTabList) {
                this.getCreateObjectivePacket().objectiveKey(this.tabListKey).sendPacket(player);
                new SClientboundSetDisplayObjectivePacket().objectiveKey(this.tabListKey).slot(SClientboundSetDisplayObjectivePacket.DisplaySlot.PLAYER_LIST).sendPacket(player);
                this.values.forEach((s, integer) -> this.createScorePacket((String)s, (int)integer).objectiveKey(this.tabListKey).sendPacket(player));
            }
        }
    }

    @Override
    public void onViewerRemoved(PlayerWrapper player, boolean checkDistance) {
        this.getDestroyObjectivePacket().objectiveKey(this.underNameTagKey).sendPacket(player);
        if (this.healthInTabList) {
            this.getDestroyObjectivePacket().objectiveKey(this.tabListKey).sendPacket(player);
        }
    }

    @Override
    protected void update0() {
        if (this.visible) {
            ArrayList<AbstractPacket> packets = new ArrayList<AbstractPacket>();
            List<PlayerWrapper> trackedPlayers = List.copyOf(this.trackedPlayers);
            List.copyOf(this.values.keySet()).stream().filter(s -> trackedPlayers.stream().noneMatch(p -> p.getName().equals(s))).forEach(s -> {
                this.values.remove(s);
                packets.add(this.getDestroyScorePacket((String)s).objectiveKey(this.underNameTagKey));
                if (this.healthInTabList) {
                    packets.add(this.getDestroyScorePacket((String)s).objectiveKey(this.tabListKey));
                }
            });
            trackedPlayers.forEach(playerWrapper -> {
                if (!playerWrapper.isOnline()) {
                    this.removeViewer((PlayerWrapper)playerWrapper);
                    return;
                }
                int health = (int)Math.round(playerWrapper.as(EntityHuman.class).getHealth());
                String key = playerWrapper.getName();
                if (!this.values.containsKey(key) || this.values.get(key) != health) {
                    this.values.put(key, health);
                    packets.add(this.createScorePacket(key, health).objectiveKey(this.underNameTagKey));
                    if (this.healthInTabList) {
                        packets.add(this.createScorePacket(key, health).objectiveKey(this.tabListKey));
                    }
                }
            });
            packets.forEach(packet -> packet.sendPacket(this.viewers));
        }
    }

    private SClientboundSetObjectivePacket getNotFinalObjectivePacket() {
        return new SClientboundSetObjectivePacket().title(this.symbol.asComponent()).criteriaType(SClientboundSetObjectivePacket.Type.INTEGER);
    }

    private SClientboundSetObjectivePacket getCreateObjectivePacket() {
        SClientboundSetObjectivePacket packet = this.getNotFinalObjectivePacket();
        packet.mode(SClientboundSetObjectivePacket.Mode.CREATE);
        return packet;
    }

    private SClientboundSetObjectivePacket getUpdateObjectivePacket() {
        SClientboundSetObjectivePacket packet = this.getNotFinalObjectivePacket();
        packet.mode(SClientboundSetObjectivePacket.Mode.UPDATE);
        return packet;
    }

    private SClientboundSetObjectivePacket getDestroyObjectivePacket() {
        return new SClientboundSetObjectivePacket().mode(SClientboundSetObjectivePacket.Mode.DESTROY);
    }

    private SClientboundSetScorePacket createScorePacket(String key, int score) {
        return new SClientboundSetScorePacket().entityName(key).score(score).action(SClientboundSetScorePacket.ScoreboardAction.CHANGE);
    }

    private SClientboundSetScorePacket getDestroyScorePacket(String key) {
        return new SClientboundSetScorePacket().entityName(key).action(SClientboundSetScorePacket.ScoreboardAction.REMOVE);
    }

    private static String generateObjectiveKey() {
        return new Random().ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(16L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    @Override
    public DataContainer getData() {
        return this.data;
    }

    @Override
    public HealthIndicatorImpl setData(DataContainer data) {
        this.data = data;
        return this;
    }
}

