/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.hologram;

import io.github.pronze.lib.screaminglib.hologram.HologramManager;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.tasker.TaskerTime;
import io.github.pronze.lib.screaminglib.utils.Pair;
import io.github.pronze.lib.screaminglib.visuals.DatableVisual;
import io.github.pronze.lib.screaminglib.visuals.LinedVisual;
import io.github.pronze.lib.screaminglib.visuals.TouchableVisual;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import java.util.Map;

public interface Hologram
extends LinedVisual<Hologram>,
DatableVisual<Hologram>,
TouchableVisual<Hologram> {
    public static final float DEFAULT_ROTATION_INCREMENT = 10.0f;

    public static Hologram of(LocationHolder location) {
        return HologramManager.hologram(location);
    }

    public static Hologram touchableOf(LocationHolder location) {
        return HologramManager.hologram(location, true);
    }

    public Pair<Integer, TaskerTime> getRotationTime();

    public Hologram setRotationTime(Pair<Integer, TaskerTime> var1);

    public RotationMode getRotationMode();

    public Hologram setRotationMode(RotationMode var1);

    public Hologram setRotationIncrement(float var1);

    public Hologram setItem(Item var1);

    public Hologram setItemPosition(ItemPosition var1);

    public ItemPosition getItemPosition();

    public static interface Data {
        public Map<String, Object> getAll();

        public <T> T get(String var1);

        public boolean contains(String var1);

        public void set(String var1, Object var2);

        public void add(String var1, Object var2);
    }

    public static enum ItemPosition {
        ABOVE,
        BELOW;

    }

    public static enum RotationMode {
        X,
        Y,
        Z,
        ALL,
        XY,
        NONE;

    }
}

