/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.hologram;

import io.github.pronze.lib.screaminglib.hologram.Hologram;
import io.github.pronze.lib.screaminglib.hologram.HologramManager;
import io.github.pronze.lib.screaminglib.hologram.HologramPiece;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundRemoveEntitiesPacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetEntityDataPacket;
import io.github.pronze.lib.screaminglib.packet.SClientboundSetEquipmentPacket;
import io.github.pronze.lib.screaminglib.packet.entity.FakeEntity;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.sender.SenderMessage;
import io.github.pronze.lib.screaminglib.slot.EquipmentSlotHolder;
import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.lib.screaminglib.tasker.TaskerTime;
import io.github.pronze.lib.screaminglib.tasker.task.TaskState;
import io.github.pronze.lib.screaminglib.tasker.task.TaskerTask;
import io.github.pronze.lib.screaminglib.utils.Pair;
import io.github.pronze.lib.screaminglib.utils.data.DataContainer;
import io.github.pronze.lib.screaminglib.utils.math.Vector3Df;
import io.github.pronze.lib.screaminglib.utils.visual.SimpleCLTextEntry;
import io.github.pronze.lib.screaminglib.visuals.impl.AbstractLinedVisual;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HologramImpl
extends AbstractLinedVisual<Hologram>
implements Hologram {
    private final Map<Integer, HologramPiece> entitiesOnLines;
    private volatile HologramPiece itemEntity;
    private volatile TaskerTask rotationTask;
    private LocationHolder cachedLocation;
    private LocationHolder location;
    private int viewDistance;
    private boolean touchable;
    private boolean destroyed;
    private boolean created;
    private DataContainer data;
    private float rotationIncrement;
    private Pair<Integer, TaskerTime> rotationTime;
    private Hologram.RotationMode rotationMode;
    private Item item;
    private Hologram.ItemPosition itemPosition;
    private long clickCoolDown;

    public HologramImpl(UUID uuid, LocationHolder location, boolean touchable) {
        super(uuid);
        this.location = location;
        this.touchable = touchable;
        this.destroyed = false;
        this.created = false;
        this.clickCoolDown = 20L;
        this.viewDistance = 4096;
        this.rotationIncrement = 10.0f;
        this.data = DataContainer.get();
        this.rotationTime = Pair.of(2, TaskerTime.TICKS);
        this.rotationMode = Hologram.RotationMode.NONE;
        this.itemPosition = Hologram.ItemPosition.ABOVE;
        this.entitiesOnLines = new ConcurrentHashMap<Integer, HologramPiece>();
        this.cachedLocation = location;
    }

    @Override
    public Hologram setLocation(LocationHolder location) {
        this.location = location;
        this.cachedLocation = location;
        return this;
    }

    @Override
    public Hologram spawn() {
        if (this.created) {
            throw new UnsupportedOperationException("Hologram has already been spawned!");
        }
        this.show();
        this.created = true;
        return this;
    }

    @Override
    public boolean hasId(int entityId) {
        return this.entitiesOnLines.values().stream().anyMatch(entity -> entity.getId() == entityId);
    }

    @Override
    public Hologram update() {
        if (this.visible) {
            this.update0();
        }
        return this;
    }

    @Override
    public Hologram show() {
        if (this.isDestroyed()) {
            throw new UnsupportedOperationException("Cannot call Hologram#show() on destroyed holograms!");
        }
        this.visible = true;
        this.update();
        this.startRotationTask();
        return this;
    }

    @Override
    public Hologram hide() {
        if (!this.isShown()) {
            return this;
        }
        this.visible = false;
        this.viewers.forEach(viewer -> this.onViewerRemoved((PlayerWrapper)viewer, false));
        this.cancelRotationTask();
        return this;
    }

    @Override
    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    @Override
    public Hologram setRotationTime(Pair<Integer, TaskerTime> rotatingTime) {
        this.rotationTime = rotatingTime;
        this.update();
        this.restartRotationTask();
        return this;
    }

    @Override
    public Hologram setRotationMode(Hologram.RotationMode mode) {
        this.rotationMode = mode;
        this.update();
        this.restartRotationTask();
        return this;
    }

    @Override
    public Hologram setItem(Item item) {
        this.item = item;
        this.update();
        this.restartRotationTask();
        return this;
    }

    @Override
    public Hologram setItemPosition(Hologram.ItemPosition location) {
        this.itemPosition = location;
        this.update();
        this.restartRotationTask();
        return this;
    }

    @Override
    public void destroy() {
        if (this.isDestroyed()) {
            return;
        }
        this.hide();
        this.viewers.clear();
        this.visible = false;
        this.destroyed = true;
        this.data = null;
        HologramManager.removeHologram(this);
    }

    @Override
    public void onViewerAdded(PlayerWrapper viewer, boolean checkDistance) {
        if (!viewer.isOnline()) {
            return;
        }
        if (this.visible && this.entitiesOnLines.size() != this.lines.size()) {
            this.updateEntities();
        }
        this.update(viewer, this.getAllSpawnPackets(viewer), checkDistance);
    }

    @Override
    public void onViewerRemoved(PlayerWrapper viewer, boolean checkDistance) {
        if (!viewer.isOnline()) {
            return;
        }
        LinkedList<AbstractPacket> toSend = new LinkedList<AbstractPacket>();
        if (this.itemEntity != null || this.entitiesOnLines.size() > 0) {
            toSend.add(this.getFullDestroyPacket());
            this.update(viewer, toSend, false);
        }
    }

    private void update(PlayerWrapper player, List<AbstractPacket> packets, boolean checkDistance) {
        if (!player.getLocation().getWorld().equals(this.cachedLocation.getWorld())) {
            return;
        }
        if (checkDistance && player.getLocation().getDistanceSquared(this.cachedLocation) >= (double)this.viewDistance) {
            return;
        }
        packets.forEach(packet -> packet.sendPacket(player));
    }

    private void updateEntities() {
        LinkedList<Function<PlayerWrapper, List>> packets = new LinkedList<Function<PlayerWrapper, List>>();
        if (this.visible && this.viewers.size() > 0) {
            if (this.lines.size() != this.originalLinesSize.intValue() && this.itemEntity != null) {
                this.itemEntity.setLocation(this.cachedLocation.clone().add(0.0, this.itemPosition == Hologram.ItemPosition.BELOW ? (double)(-this.lines.size()) * 0.25 - 0.5 : (double)this.lines.size() * 0.25, 0.0));
                packets.add(p -> List.of(this.itemEntity.getTeleportPacket()));
            }
            this.lines.forEach((key, value) -> {
                try {
                    if (this.entitiesOnLines.containsKey(key)) {
                        boolean isSenderMessage;
                        HologramPiece entityOnLine = this.entitiesOnLines.get(key);
                        boolean bl = isSenderMessage = value instanceof SimpleCLTextEntry && ((SimpleCLTextEntry)value).getComponentLike() instanceof SenderMessage;
                        if (this.originalLinesSize.intValue() == this.lines.size() && (isSenderMessage ? entityOnLine.getCustomNameSenderMessage() != null && entityOnLine.getCustomNameSenderMessage().equals(((SimpleCLTextEntry)value).getComponentLike()) : entityOnLine.getCustomName().equals(value.getText()))) {
                            return;
                        }
                        entityOnLine.setCustomName(value.getText());
                        entityOnLine.setCustomNameSenderMessage(isSenderMessage ? (SenderMessage)((SimpleCLTextEntry)value).getComponentLike() : null);
                        packets.add(p -> List.of(entityOnLine.getMetadataPacket((PlayerWrapper)p)));
                        entityOnLine.setLocation(this.cachedLocation.clone().add(0.0, (double)(this.lines.size() - key) * 0.25, 0.0));
                        packets.add(p -> List.of(entityOnLine.getTeleportPacket()));
                    } else {
                        LocationHolder newLocation = this.cachedLocation.clone().add(0.0, (double)(this.lines.size() - key) * 0.25, 0.0);
                        HologramPiece entity = new HologramPiece(newLocation);
                        entity.setCustomName(value.getText());
                        if (value instanceof SimpleCLTextEntry && ((SimpleCLTextEntry)value).getComponentLike() instanceof SenderMessage) {
                            entity.setCustomNameSenderMessage((SenderMessage)((SimpleCLTextEntry)value).getComponentLike());
                        }
                        entity.setCustomNameVisible(true);
                        entity.setInvisible(true);
                        entity.setSmall(!this.touchable);
                        entity.setArms(false);
                        entity.setBasePlate(false);
                        entity.setGravity(false);
                        entity.setMarker(!this.touchable);
                        packets.add(entity::getSpawnPackets);
                        this.entitiesOnLines.put((Integer)key, entity);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            });
            try {
                if (this.rotationMode != Hologram.RotationMode.NONE && this.itemEntity == null) {
                    LocationHolder newLocation = this.cachedLocation.clone().add(0.0, this.itemPosition == Hologram.ItemPosition.BELOW ? (double)(-this.lines.size()) * 0.25 - 0.5 : (double)this.lines.size() * 0.25, 0.0);
                    HologramPiece entity = new HologramPiece(newLocation);
                    entity.setInvisible(true);
                    entity.setSmall(!this.touchable);
                    entity.setArms(false);
                    entity.setBasePlate(false);
                    entity.setGravity(false);
                    entity.setMarker(!this.touchable);
                    packets.add(entity::getSpawnPackets);
                    packets.add(p -> List.of(this.getEquipmentPacket(entity, this.item)));
                    this.itemEntity = entity;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        try {
            LinkedList toRemove = new LinkedList();
            if (this.entitiesOnLines.size() > this.lines.size()) {
                this.entitiesOnLines.forEach((key, value) -> {
                    if (!this.lines.containsKey(key)) {
                        toRemove.add(value.getId());
                    }
                });
            }
            SClientboundRemoveEntitiesPacket destroyPacket = new SClientboundRemoveEntitiesPacket();
            int[] arr = toRemove.stream().mapToInt(i -> i).toArray();
            if (arr != null && arr.length > 0) {
                destroyPacket.entityIds(toRemove.stream().mapToInt(i -> i).toArray());
                packets.add(p -> List.of(destroyPacket));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.viewers.forEach(viewer -> this.update((PlayerWrapper)viewer, packets.stream().map(f -> (List)f.apply(viewer)).flatMap(Collection::stream).collect(Collectors.toList()), true));
    }

    private SClientboundSetEquipmentPacket getEquipmentPacket(HologramPiece entity, Item item) {
        SClientboundSetEquipmentPacket packet = new SClientboundSetEquipmentPacket().entityId(entity.getId());
        packet.slots().put(EquipmentSlotHolder.of("HEAD"), item);
        return packet;
    }

    private SClientboundRemoveEntitiesPacket getFullDestroyPacket() {
        Stream<Integer> lines = this.entitiesOnLines.values().stream().map(FakeEntity::getId);
        int[] toRemove = this.itemEntity != null ? Stream.concat(lines, Stream.of(Integer.valueOf(this.itemEntity.getId()))).mapToInt(i -> i).toArray() : lines.mapToInt(i -> i).toArray();
        SClientboundRemoveEntitiesPacket destroyPacket = new SClientboundRemoveEntitiesPacket();
        if (toRemove != null && toRemove.length > 0) {
            destroyPacket.entityIds(toRemove);
        }
        return destroyPacket;
    }

    private List<AbstractPacket> getAllSpawnPackets(PlayerWrapper viewer) {
        LinkedList<AbstractPacket> packets = new LinkedList<AbstractPacket>();
        this.entitiesOnLines.forEach((line, entity) -> packets.addAll(entity.getSpawnPackets(viewer)));
        if (this.itemEntity != null) {
            packets.addAll(this.itemEntity.getSpawnPackets());
            packets.add(this.getEquipmentPacket(this.itemEntity, this.item));
        }
        return packets;
    }

    private Vector3Df checkAndAdd(Vector3Df in) {
        Vector3Df toReturn = new Vector3Df();
        switch (this.rotationMode) {
            case X: {
                toReturn.setX(this.checkAndIncrement(in.getX()));
                break;
            }
            case Y: {
                toReturn.setY(this.checkAndIncrement(in.getY()));
                break;
            }
            case Z: {
                toReturn.setZ(this.checkAndIncrement(in.getZ()));
                break;
            }
            case XY: {
                toReturn.setX(this.checkAndIncrement(in.getX()));
                toReturn.setY(this.checkAndIncrement(in.getY()));
                break;
            }
            case ALL: {
                toReturn.setX(this.checkAndIncrement(in.getX()));
                toReturn.setY(this.checkAndIncrement(in.getY()));
                toReturn.setZ(this.checkAndIncrement(in.getZ()));
            }
        }
        return toReturn;
    }

    private float checkAndIncrement(float in) {
        if (in >= 370.0f) {
            return 0.0f;
        }
        return in + this.rotationIncrement;
    }

    private void startRotationTask() {
        if (this.rotationMode != Hologram.RotationMode.NONE && this.rotationTask == null) {
            this.rotationTask = Tasker.build(() -> {
                if (this.itemEntity == null || !this.visible) {
                    return;
                }
                this.itemEntity.setHeadRotation(this.checkAndAdd(this.itemEntity.getHeadRotation()));
                SClientboundSetEntityDataPacket metadataPacket = new SClientboundSetEntityDataPacket().entityId(this.itemEntity.getId());
                metadataPacket.metadata().addAll(this.itemEntity.getMetadataItems());
                this.viewers.forEach(player -> this.update((PlayerWrapper)player, List.of(metadataPacket), false));
            }).repeat(this.rotationTime.getFirst().intValue(), this.rotationTime.getSecond()).async().start();
        }
    }

    private void cancelRotationTask() {
        if (this.rotationTask != null && this.rotationTask.getState() != TaskState.CANCELLED) {
            this.rotationTask.cancel();
            this.rotationTask = null;
        }
    }

    private void restartRotationTask() {
        this.cancelRotationTask();
        this.startRotationTask();
    }

    @Override
    protected void update0() {
        this.updateEntities();
    }

    public TaskerTask getRotationTask() {
        return this.rotationTask;
    }

    public LocationHolder getCachedLocation() {
        return this.cachedLocation;
    }

    @Override
    public LocationHolder getLocation() {
        return this.location;
    }

    @Override
    public int getViewDistance() {
        return this.viewDistance;
    }

    @Override
    public boolean isTouchable() {
        return this.touchable;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean isCreated() {
        return this.created;
    }

    @Override
    public DataContainer getData() {
        return this.data;
    }

    public float getRotationIncrement() {
        return this.rotationIncrement;
    }

    @Override
    public Pair<Integer, TaskerTime> getRotationTime() {
        return this.rotationTime;
    }

    @Override
    public Hologram.RotationMode getRotationMode() {
        return this.rotationMode;
    }

    public Item getItem() {
        return this.item;
    }

    @Override
    public long getClickCoolDown() {
        return this.clickCoolDown;
    }

    public HologramImpl setItemEntity(HologramPiece itemEntity) {
        this.itemEntity = itemEntity;
        return this;
    }

    public HologramImpl setRotationTask(TaskerTask rotationTask) {
        this.rotationTask = rotationTask;
        return this;
    }

    public HologramImpl setCachedLocation(LocationHolder cachedLocation) {
        this.cachedLocation = cachedLocation;
        return this;
    }

    @Override
    public HologramImpl setViewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
        return this;
    }

    @Override
    public HologramImpl setTouchable(boolean touchable) {
        this.touchable = touchable;
        return this;
    }

    public HologramImpl setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
        return this;
    }

    public HologramImpl setCreated(boolean created) {
        this.created = created;
        return this;
    }

    @Override
    public HologramImpl setData(DataContainer data) {
        this.data = data;
        return this;
    }

    @Override
    public HologramImpl setRotationIncrement(float rotationIncrement) {
        this.rotationIncrement = rotationIncrement;
        return this;
    }

    @Override
    public HologramImpl setClickCoolDown(long clickCoolDown) {
        this.clickCoolDown = clickCoolDown;
        return this;
    }

    @Override
    public Hologram.ItemPosition getItemPosition() {
        return this.itemPosition;
    }
}

