/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.hologram;

import io.github.pronze.lib.screaminglib.event.EventManager;
import io.github.pronze.lib.screaminglib.hologram.Hologram;
import io.github.pronze.lib.screaminglib.hologram.HologramImpl;
import io.github.pronze.lib.screaminglib.hologram.event.HologramTouchEvent;
import io.github.pronze.lib.screaminglib.item.builder.ItemFactory;
import io.github.pronze.lib.screaminglib.packet.PacketMapper;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.lib.screaminglib.utils.InteractType;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.visuals.AbstractVisualsManager;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.github.pronze.lib.screaminglib.world.LocationMapper;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

@Service(dependsOn={EventManager.class, PlayerMapper.class, LocationMapper.class, Tasker.class, ItemFactory.class, PacketMapper.class})
public class HologramManager
extends AbstractVisualsManager<Hologram> {
    private static HologramManager manager = null;

    public HologramManager() {
        if (manager != null) {
            throw new UnsupportedOperationException("HologramManager is already initialized");
        }
        manager = this;
    }

    public static Hologram hologram(LocationHolder holder) {
        return HologramManager.hologram(UUID.randomUUID(), holder, false);
    }

    public static Hologram hologram(LocationHolder holder, boolean touchable) {
        return HologramManager.hologram(UUID.randomUUID(), holder, touchable);
    }

    public static Hologram hologram(UUID uuid, LocationHolder holder) {
        return HologramManager.hologram(uuid, holder, false);
    }

    public static Hologram hologram(UUID uuid, LocationHolder holder, boolean touchable) {
        if (manager == null) {
            throw new UnsupportedOperationException("HologramManager is not initialized yet!");
        }
        HologramImpl hologram = new HologramImpl(uuid, holder, touchable);
        HologramManager.addHologram(hologram);
        return hologram;
    }

    public static Map<UUID, Hologram> getActiveHolograms() {
        if (manager == null) {
            throw new UnsupportedOperationException("HologramManager is not initialized yet!");
        }
        return manager.getActiveVisuals();
    }

    public static Optional<Hologram> getHologram(UUID uuid) {
        if (manager == null) {
            throw new UnsupportedOperationException("HologramManager is not initialized yet!");
        }
        return Optional.ofNullable(HologramManager.getActiveHolograms().get(uuid));
    }

    public static void addHologram(Hologram hologram) {
        if (manager == null) {
            throw new UnsupportedOperationException("HologramManager is not initialized yet!");
        }
        manager.addVisual(hologram.getUuid(), hologram);
    }

    public static void removeHologram(UUID uuid) {
        HologramManager.getHologram(uuid).ifPresent(HologramManager::removeHologram);
    }

    public static void removeHologram(Hologram hologram) {
        if (manager == null) {
            throw new UnsupportedOperationException("HologramManager is not initialized yet!");
        }
        manager.removeVisual(hologram.getUuid());
    }

    @Override
    public void fireVisualTouchEvent(PlayerWrapper sender, Hologram visual, InteractType interactType) {
        EventManager.fireAsync(new HologramTouchEvent(sender, visual, interactType));
    }
}

