/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.item;

import java.util.HashMap;
import java.util.Map;

public enum HideFlags {
    ENCHANTMENTS("HIDE_ENCHANTS"),
    ATTRIBUTE_MODIFIERS("HIDE_ATTRIBUTES"),
    UNBREAKABLE("HIDE_UNBREAKABLE"),
    CAN_DESTROY("HIDE_DESTROYS"),
    CAN_PLACE_ON("HIDE_PLACED_ON"),
    MISC("HIDE_POTION_EFFECTS"),
    DYED("HIDE_DYE");

    private final String bukkitName;
    private static final Map<String, HideFlags> VALUES;

    public static HideFlags convert(String name) {
        return VALUES.getOrDefault(name.toUpperCase(), MISC);
    }

    private HideFlags(String bukkitName) {
        this.bukkitName = bukkitName;
    }

    public String getBukkitName() {
        return this.bukkitName;
    }

    static {
        VALUES = new HashMap<String, HideFlags>();
        for (HideFlags flag : HideFlags.values()) {
            VALUES.put(flag.name(), flag);
            VALUES.put(flag.bukkitName, flag);
        }
    }
}

