/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.item;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.screaminglib.ItemBlockIdsRemapper;
import io.github.pronze.lib.screaminglib.configurate.ItemTypeHolderSerializer;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.OfMethodAlternative;
import io.github.pronze.lib.screaminglib.utils.key.ComplexMappingKey;
import io.github.pronze.lib.screaminglib.utils.key.MappingKey;
import io.github.pronze.lib.screaminglib.utils.key.NamespacedMappingKey;
import io.github.pronze.lib.screaminglib.utils.key.NumericMappingKey;
import io.github.pronze.lib.screaminglib.utils.mapper.AbstractTypeMapper;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;

@AbstractService
public abstract class ItemTypeMapper
extends AbstractTypeMapper<ItemTypeHolder> {
    private static final Pattern RESOLUTION_PATTERN = Pattern.compile("^(((?<namespaced>(?:([A-Za-z][A-Za-z0-9_.\\-]*):)?[A-Za-z][A-Za-z0-9_.\\-/ ]*)(?::)?(?<durability>\\d+)?)|((?<id>\\d+)(?::)?(?<data>\\d+)?))$");
    protected BidirectionalConverter<ItemTypeHolder> itemTypeConverter = BidirectionalConverter.build().registerP2W(ItemTypeHolder.class, i -> i).registerP2W(ConfigurationNode.class, node -> {
        try {
            return ItemTypeHolderSerializer.INSTANCE.deserialize((Type)((Object)ItemTypeHolder.class), (ConfigurationNode)node);
        }
        catch (SerializationException ex) {
            ex.printStackTrace();
            return null;
        }
    });
    private static ItemTypeMapper itemTypeMapper;
    private static ItemTypeHolder cachedAir;

    @ApiStatus.Internal
    public ItemTypeMapper() {
        if (itemTypeMapper != null) {
            throw new UnsupportedOperationException("ItemTypeMapper is already initialized.");
        }
        itemTypeMapper = this;
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.MATERIAL)
    @OfMethodAlternative(value=ItemTypeHolder.class, methodName="ofOptional")
    public static Optional<ItemTypeHolder> resolve(Object materialObject) {
        if (itemTypeMapper == null) {
            throw new UnsupportedOperationException("ItemTypeMapper is not initialized yet.");
        }
        if (materialObject == null) {
            return Optional.empty();
        }
        return ItemTypeMapper.itemTypeMapper.itemTypeConverter.convertOptional(materialObject).or(() -> {
            String material = materialObject.toString().trim();
            Matcher matcher = RESOLUTION_PATTERN.matcher(material);
            if (matcher.matches()) {
                if (matcher.group("namespaced") != null) {
                    NamespacedMappingKey namespaced = NamespacedMappingKey.of(matcher.group("namespaced"));
                    Integer data = null;
                    try {
                        data = Integer.parseInt(matcher.group("durability"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (data != null) {
                        ComplexMappingKey namespacedDurability = ComplexMappingKey.of(namespaced, NumericMappingKey.of(data));
                        if (ItemTypeMapper.itemTypeMapper.mapping.containsKey(namespacedDurability)) {
                            return Optional.of((ItemTypeHolder)ItemTypeMapper.itemTypeMapper.mapping.get(namespacedDurability));
                        }
                        if (ItemTypeMapper.itemTypeMapper.mapping.containsKey(namespaced)) {
                            ItemTypeHolder holder = (ItemTypeHolder)ItemTypeMapper.itemTypeMapper.mapping.get(namespaced);
                            return Optional.of(holder.withForcedDurability(data.shortValue()));
                        }
                    } else if (ItemTypeMapper.itemTypeMapper.mapping.containsKey(namespaced)) {
                        return Optional.of((ItemTypeHolder)ItemTypeMapper.itemTypeMapper.mapping.get(namespaced));
                    }
                } else if (matcher.group("id") != null) {
                    try {
                        int id = Integer.parseInt(matcher.group("id"));
                        int data = 0;
                        try {
                            data = Integer.parseInt(matcher.group("data"));
                        }
                        catch (NumberFormatException namespacedDurability) {
                            // empty catch block
                        }
                        ComplexMappingKey keyWithData = ComplexMappingKey.of(NumericMappingKey.of(id), NumericMappingKey.of(data));
                        NumericMappingKey key = NumericMappingKey.of(id);
                        if (ItemTypeMapper.itemTypeMapper.mapping.containsKey(keyWithData)) {
                            return Optional.of((ItemTypeHolder)ItemTypeMapper.itemTypeMapper.mapping.get(keyWithData));
                        }
                        if (ItemTypeMapper.itemTypeMapper.mapping.containsKey(key)) {
                            ItemTypeHolder holder = (ItemTypeHolder)ItemTypeMapper.itemTypeMapper.mapping.get(key);
                            return Optional.of(holder.withForcedDurability((short)data));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return Optional.empty();
        });
    }

    @OfMethodAlternative(value=ItemTypeHolder.class, methodName="all")
    public static List<ItemTypeHolder> getValues() {
        if (itemTypeMapper == null) {
            throw new UnsupportedOperationException("ItemTypeMapper is not initialized yet.");
        }
        return Collections.unmodifiableList(ItemTypeMapper.itemTypeMapper.values);
    }

    public static ItemTypeHolder colorize(ItemTypeHolder holder, String color) {
        if (itemTypeMapper == null) {
            throw new UnsupportedOperationException("ItemTypeMapper is not initialized yet.");
        }
        return ItemBlockIdsRemapper.colorableItems.entrySet().stream().filter(c -> ((Predicate)c.getKey()).test(holder)).map(Map.Entry::getValue).findFirst().flatMap(fun -> (Optional)fun.apply(color)).orElse(holder);
    }

    public Map<MappingKey, ItemTypeHolder> getUNSAFE_mapping() {
        return this.mapping;
    }

    @Override
    public void mapAlias(String mappingKey, String alias) {
        super.mapAlias(mappingKey, alias);
    }

    @OfMethodAlternative(value=ItemTypeHolder.class, methodName="air")
    public static ItemTypeHolder getCachedAir() {
        if (cachedAir == null) {
            cachedAir = ItemTypeMapper.resolve("minecraft:air").orElseThrow();
        }
        return cachedAir;
    }
}

