/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.item.meta;

import io.github.pronze.lib.screaminglib.item.meta.PotionMapping;
import io.github.pronze.lib.screaminglib.utils.ComparableWrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import java.util.List;
import java.util.Optional;

public interface PotionHolder
extends ComparableWrapper {
    @Deprecated(forRemoval=true)
    default public String getPlatformName() {
        return this.platformName();
    }

    public String platformName();

    @CustomAutocompletion(value=CustomAutocompletion.Type.POTION)
    public static PotionHolder of(Object potion) {
        return PotionHolder.ofOptional(potion).orElseThrow();
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.POTION)
    public static Optional<PotionHolder> ofOptional(Object potion) {
        if (potion instanceof PotionHolder) {
            return Optional.of((PotionHolder)potion);
        }
        return PotionMapping.resolve(potion);
    }

    public static List<PotionHolder> all() {
        return PotionMapping.getValues();
    }

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.POTION)
    public boolean is(Object var1);

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.POTION)
    public boolean is(Object ... var1);
}

