/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.npc;

import io.github.pronze.lib.screaminglib.event.EventManager;
import io.github.pronze.lib.screaminglib.event.OnEvent;
import io.github.pronze.lib.screaminglib.event.player.SPlayerMoveEvent;
import io.github.pronze.lib.screaminglib.npc.NPC;
import io.github.pronze.lib.screaminglib.npc.NPCImpl;
import io.github.pronze.lib.screaminglib.npc.event.NPCInteractEvent;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.InteractType;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.visuals.AbstractVisualsManager;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

@Service
public class NPCManager
extends AbstractVisualsManager<NPC> {
    private static NPCManager manager = null;

    public NPCManager() {
        if (manager != null) {
            throw new UnsupportedOperationException("NPCManager has already been initialized!");
        }
        manager = this;
    }

    public static boolean isInitialized() {
        return manager != null;
    }

    public static Map<UUID, NPC> getActiveNPCS() {
        if (manager == null) {
            throw new UnsupportedOperationException("NPCManager is not initialized yet!");
        }
        return manager.getActiveVisuals();
    }

    public static Optional<NPC> getNPC(UUID uuid) {
        if (manager == null) {
            throw new UnsupportedOperationException("NPCManager is not initialized yet!");
        }
        return Optional.ofNullable(NPCManager.getActiveNPCS().get(uuid));
    }

    public static void addNPC(NPC npc) {
        if (manager == null) {
            throw new UnsupportedOperationException("NPCManager is not initialized yet!");
        }
        manager.addVisual(npc.getUuid(), npc);
    }

    public static void removeNPC(UUID uuid) {
        NPCManager.getNPC(uuid).ifPresent(NPCManager::removeNPC);
    }

    public static void removeNPC(NPC npc) {
        if (manager == null) {
            throw new UnsupportedOperationException("NPCManager is not initialized yet!");
        }
        manager.removeVisual(npc.getUuid());
    }

    public static NPC npc(LocationHolder holder) {
        return NPCManager.npc(UUID.randomUUID(), holder, true);
    }

    public static NPC npc(UUID uuid, LocationHolder holder, boolean touchable) {
        if (manager == null) {
            throw new UnsupportedOperationException("NPCManager is not initialized yet!");
        }
        NPCImpl npc = new NPCImpl(uuid, holder, touchable);
        NPCManager.addNPC(npc);
        return npc;
    }

    @OnEvent
    public void onPlayerMove(SPlayerMoveEvent event) {
        if (this.activeVisuals.isEmpty()) {
            return;
        }
        PlayerWrapper player = event.getPlayer();
        for (NPC npc : this.activeVisuals.values()) {
            if (!npc.isShown() || !npc.shouldLookAtPlayer() || !npc.getViewers().contains(player) || !player.getLocation().isWorldSame(npc.getLocation()) || npc.getLocation().getDistanceSquared(player.getLocation()) > 4096.0) continue;
            npc.lookAtLocation(event.getNewLocation(), player);
        }
    }

    @Override
    public void fireVisualTouchEvent(PlayerWrapper sender, NPC visual, InteractType interactType) {
        EventManager.fireAsync(new NPCInteractEvent(sender, visual, interactType));
    }
}

