/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.packet;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.Server;
import io.github.pronze.lib.screaminglib.packet.PacketWriter;
import io.github.pronze.lib.screaminglib.utils.math.Vector3Df;
import io.github.pronze.lib.screaminglib.utils.math.Vector3Di;

public abstract class MetadataItem {
    private final byte index;

    public void write(PacketWriter writer) {
        writer.writeByte(this.index);
    }

    public static ByteMetadataItem of(byte index, byte value) {
        return new ByteMetadataItem(index, value);
    }

    public static VarIntMetadataItem of(byte index, int value) {
        return new VarIntMetadataItem(index, value);
    }

    public static FloatMetadataItem of(byte index, float value) {
        return new FloatMetadataItem(index, value);
    }

    public static StringMetadataItem of(byte index, String value) {
        return new StringMetadataItem(index, value);
    }

    public static ComponentMetadataItem of(byte index, Component value) {
        return new ComponentMetadataItem(index, value);
    }

    public static BooleanMetadataItem of(byte index, boolean value) {
        return new BooleanMetadataItem(index, value);
    }

    public static Vector3DfMetadataItem of(byte index, Vector3Df value) {
        return new Vector3DfMetadataItem(index, value);
    }

    public static OptionalComponentMetadataItem ofOpt(byte index, Component value) {
        return new OptionalComponentMetadataItem(index, value);
    }

    public static OptionalBlockPositionMetadataItem ofOpt(byte index, Vector3Di value) {
        return new OptionalBlockPositionMetadataItem(index, value);
    }

    public static long blockPosToLong(int x, int y, int z) {
        if (Server.isVersion(1, 14)) {
            return ((long)x & 0x3FFFFFFL) << 38 | ((long)z & 0x3FFFFFFL) << 12 | (long)y & 0xFFFL;
        }
        return ((long)x & 0x3FFFFFFL) << 38 | ((long)y & 0xFFFL) << 26 | (long)z & 0x3FFFFFFL;
    }

    public MetadataItem(byte index) {
        this.index = index;
    }

    public byte getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataItem)) {
            return false;
        }
        MetadataItem other = (MetadataItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getIndex() == other.getIndex();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetadataItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        return result;
    }

    public String toString() {
        return "MetadataItem(index=" + this.getIndex() + ")";
    }

    public static class ByteMetadataItem
    extends MetadataItem {
        private final byte data;

        public ByteMetadataItem(byte index, byte data) {
            super(index);
            this.data = data;
        }

        @Override
        public void write(PacketWriter writer) {
            super.write(writer);
            writer.writeVarInt(0);
            writer.writeByte(this.data);
        }

        public byte getData() {
            return this.data;
        }

        @Override
        public String toString() {
            return "MetadataItem.ByteMetadataItem(super=" + super.toString() + ", data=" + this.getData() + ")";
        }
    }

    public static class VarIntMetadataItem
    extends MetadataItem {
        private final int data;

        public VarIntMetadataItem(byte index, int data) {
            super(index);
            this.data = data;
        }

        @Override
        public void write(PacketWriter writer) {
            super.write(writer);
            writer.writeVarInt(1);
            writer.writeVarInt(this.data);
        }

        public int getData() {
            return this.data;
        }

        @Override
        public String toString() {
            return "MetadataItem.VarIntMetadataItem(super=" + super.toString() + ", data=" + this.getData() + ")";
        }
    }

    public static class FloatMetadataItem
    extends MetadataItem {
        private final float data;

        public FloatMetadataItem(byte index, float data) {
            super(index);
            this.data = data;
        }

        @Override
        public void write(PacketWriter writer) {
            super.write(writer);
            writer.writeVarInt(2);
            writer.writeFloat(this.data);
        }

        public float getData() {
            return this.data;
        }

        @Override
        public String toString() {
            return "MetadataItem.FloatMetadataItem(super=" + super.toString() + ", data=" + this.getData() + ")";
        }
    }

    public static class StringMetadataItem
    extends MetadataItem {
        private final String text;

        public StringMetadataItem(byte index, String text) {
            super(index);
            this.text = text;
        }

        @Override
        public void write(PacketWriter writer) {
            super.write(writer);
            writer.writeVarInt(3);
            writer.writeSizedString(this.text);
        }

        public String getText() {
            return this.text;
        }

        @Override
        public String toString() {
            return "MetadataItem.StringMetadataItem(super=" + super.toString() + ", text=" + this.getText() + ")";
        }
    }

    public static class ComponentMetadataItem
    extends MetadataItem {
        private final Component text;

        public ComponentMetadataItem(byte index, Component text) {
            super(index);
            this.text = text;
        }

        @Override
        public void write(PacketWriter writer) {
            super.write(writer);
            writer.writeVarInt(4);
            writer.writeComponent(this.text);
        }

        public Component getText() {
            return this.text;
        }

        @Override
        public String toString() {
            return "MetadataItem.ComponentMetadataItem(super=" + super.toString() + ", text=" + this.getText() + ")";
        }
    }

    public static class BooleanMetadataItem
    extends MetadataItem {
        private final boolean val;

        public BooleanMetadataItem(byte index, boolean val) {
            super(index);
            this.val = val;
        }

        @Override
        public void write(PacketWriter writer) {
            super.write(writer);
            if (writer.protocol() < 393) {
                writer.writeVarInt(6);
            } else {
                writer.writeVarInt(7);
            }
            writer.writeBoolean(this.val);
        }

        public boolean isVal() {
            return this.val;
        }

        @Override
        public String toString() {
            return "MetadataItem.BooleanMetadataItem(super=" + super.toString() + ", val=" + this.isVal() + ")";
        }
    }

    public static class Vector3DfMetadataItem
    extends MetadataItem {
        private final Vector3Df val;

        public Vector3DfMetadataItem(byte index, Vector3Df val) {
            super(index);
            this.val = val;
        }

        @Override
        public void write(PacketWriter writer) {
            super.write(writer);
            if (writer.protocol() < 393) {
                writer.writeVarInt(7);
            } else {
                writer.writeVarInt(8);
            }
            writer.writeVector(this.val);
        }

        public Vector3Df getVal() {
            return this.val;
        }

        @Override
        public String toString() {
            return "MetadataItem.Vector3DfMetadataItem(super=" + super.toString() + ", val=" + this.getVal() + ")";
        }
    }

    public static class OptionalComponentMetadataItem
    extends MetadataItem {
        private final Component val;

        public OptionalComponentMetadataItem(byte index, Component val) {
            super(index);
            this.val = val;
        }

        @Override
        public void write(PacketWriter writer) {
            super.write(writer);
            writer.writeVarInt(5);
            boolean flag = this.val != null && !this.val.equals(Component.empty());
            writer.writeBoolean(flag);
            if (flag) {
                writer.writeComponent(this.val);
            }
        }

        public Component getVal() {
            return this.val;
        }

        @Override
        public String toString() {
            return "MetadataItem.OptionalComponentMetadataItem(super=" + super.toString() + ", val=" + this.getVal() + ")";
        }
    }

    public static class OptionalBlockPositionMetadataItem
    extends MetadataItem {
        private final Vector3Di blockPosition;

        public OptionalBlockPositionMetadataItem(byte index, Vector3Di blockPosition) {
            super(index);
            this.blockPosition = blockPosition;
        }

        @Override
        public void write(PacketWriter writer) {
            super.write(writer);
            if (writer.protocol() < 393) {
                writer.writeVarInt(9);
            } else {
                writer.writeVarInt(10);
            }
            boolean present = this.blockPosition != null;
            writer.writeBoolean(present);
            if (present) {
                writer.writeLong(OptionalBlockPositionMetadataItem.blockPosToLong(this.blockPosition.getX(), this.blockPosition.getY(), this.blockPosition.getZ()));
            }
        }

        public Vector3Di getBlockPosition() {
            return this.blockPosition;
        }

        @Override
        public String toString() {
            return "MetadataItem.OptionalBlockPositionMetadataItem(super=" + super.toString() + ", blockPosition=" + this.getBlockPosition() + ")";
        }
    }

    public static class BlockPositionMetadataItem
    extends MetadataItem {
        private final Vector3Di val;

        public BlockPositionMetadataItem(byte index, Vector3Di val) {
            super(index);
            this.val = val;
        }

        @Override
        public void write(PacketWriter writer) {
            super.write(writer);
            if (writer.protocol() < 393) {
                writer.writeVarInt(8);
            } else {
                writer.writeVarInt(9);
            }
            writer.writeLong(BlockPositionMetadataItem.blockPosToLong(this.val.getX(), this.val.getY(), this.val.getZ()));
        }

        public Vector3Di getVal() {
            return this.val;
        }

        @Override
        public String toString() {
            return "MetadataItem.BlockPositionMetadataItem(super=" + super.toString() + ", val=" + this.getVal() + ")";
        }
    }
}

