/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.packet;

import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.ProtocolInjector;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ServiceDependencies;

@AbstractService
@ServiceDependencies(dependsOn={ProtocolInjector.class})
public abstract class PacketMapper {
    private static PacketMapper packetMapper = null;

    public PacketMapper() {
        if (packetMapper != null) {
            throw new UnsupportedOperationException("PacketMapper is already initialized.");
        }
        packetMapper = this;
    }

    public static boolean isInitialized() {
        return packetMapper != null;
    }

    public static void sendPacket(PlayerWrapper player, AbstractPacket packet) {
        if (packetMapper == null) {
            throw new UnsupportedOperationException("PacketMapper isn't initialized yet.");
        }
        packetMapper.sendPacket0(player, packet);
    }

    public abstract void sendPacket0(PlayerWrapper var1, AbstractPacket var2);

    public static int getId(Class<? extends AbstractPacket> clazz) {
        if (packetMapper == null) {
            throw new UnsupportedOperationException("PacketMapper isn't initialized yet.");
        }
        return packetMapper.getId0(clazz);
    }

    public static int getProtocolVersion(PlayerWrapper player) {
        if (packetMapper == null) {
            throw new UnsupportedOperationException("PacketMapper isn't initialized yet.");
        }
        if (player == null || !player.isOnline()) {
            throw new UnsupportedOperationException("Invalid player provided!");
        }
        return packetMapper.getProtocolVersion0(player);
    }

    public static int getArmorStandTypeId() {
        if (packetMapper == null) {
            throw new UnsupportedOperationException("PacketMapper isn't initialized yet.");
        }
        return packetMapper.getArmorStandTypeId0();
    }

    public abstract int getId0(Class<? extends AbstractPacket> var1);

    public abstract int getProtocolVersion0(PlayerWrapper var1);

    public abstract int getArmorStandTypeId0();
}

