/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.packet;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.Server;
import io.github.pronze.lib.screaminglib.event.EventManager;
import io.github.pronze.lib.screaminglib.event.EventPriority;
import io.github.pronze.lib.screaminglib.event.player.SPlayerJoinEvent;
import io.github.pronze.lib.screaminglib.event.player.SPlayerLeaveEvent;
import io.github.pronze.lib.screaminglib.event.player.SPlayerLoginEvent;
import io.github.pronze.lib.screaminglib.packet.event.SPacketEvent;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.PacketMethod;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.ServiceDependencies;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPreDisable;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.concurrent.CompletableFuture;

@Service(dependsOn={EventManager.class})
@ServiceDependencies(dependsOn={EventManager.class, PlayerMapper.class})
public class ProtocolInjector {
    private static final String CHANNEL_NAME = "SPacketInboundOutboundChannelHandler";

    @OnPostEnable
    public void onPostEnable() {
        EventManager.getDefaultEventManager().register(SPlayerLoginEvent.class, sPlayerLoginEvent -> this.addPlayer(sPlayerLoginEvent.getPlayer(), true), EventPriority.LOWEST);
        EventManager.getDefaultEventManager().register(SPlayerJoinEvent.class, sPlayerJoinEvent -> this.addPlayer(sPlayerJoinEvent.getPlayer(), false), EventPriority.HIGH);
        EventManager.getDefaultEventManager().register(SPlayerLeaveEvent.class, sPlayerLeaveEvent -> this.removePlayer(sPlayerLeaveEvent.getPlayer()), EventPriority.HIGHEST);
        Server.getConnectedPlayers().forEach(player -> this.addPlayer((PlayerWrapper)player, false));
    }

    @OnPreDisable
    public void onPreDisable() {
        Server.getConnectedPlayers().forEach(this::removePlayer);
    }

    public void addPlayer(PlayerWrapper player, boolean onLogin) {
        try {
            Channel channel = player.getChannel();
            if (channel == null) {
                throw new UnsupportedOperationException("Failed to find player channel!");
            }
            PacketHandler handler = new PacketHandler(player);
            if (channel.pipeline().get(CHANNEL_NAME) == null && channel.pipeline().get("packet_handler") != null) {
                Runnable task = () -> channel.pipeline().addBefore("packet_handler", CHANNEL_NAME, (ChannelHandler)handler);
                if (channel.eventLoop().inEventLoop()) {
                    task.run();
                } else {
                    channel.eventLoop().submit(task);
                }
            }
        }
        catch (Throwable t) {
            if (onLogin) {
                return;
            }
            t.printStackTrace();
            player.kick(Component.text("Failed to inject!, please rejoin.."));
        }
    }

    public void removePlayer(PlayerWrapper player) {
        try {
            Channel ch = player.getChannel();
            if (ch != null && ch.pipeline().get(CHANNEL_NAME) != null) {
                Runnable task = () -> ch.pipeline().remove(CHANNEL_NAME);
                if (ch.eventLoop().inEventLoop()) {
                    task.run();
                } else {
                    ch.eventLoop().submit(task);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class PacketHandler
    extends ChannelDuplexHandler {
        private final PlayerWrapper player;

        public void channelRead(ChannelHandlerContext ctx, Object packet) {
            CompletableFuture<SPacketEvent> future = EventManager.fireAsync(new SPacketEvent(this.player, PacketMethod.INBOUND, packet));
            future.thenAccept(event -> {
                if (event.isCancelled()) {
                    return;
                }
                Object modifiedPacket = event.getPacket();
                try {
                    super.channelRead(ctx, modifiedPacket);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            });
        }

        public void write(ChannelHandlerContext ctx, Object packet, ChannelPromise promise) {
            CompletableFuture<SPacketEvent> future = EventManager.fireAsync(new SPacketEvent(this.player, PacketMethod.OUTBOUND, packet));
            future.thenAccept(event -> {
                if (event.isCancelled()) {
                    return;
                }
                Object modifiedPacket = event.getPacket();
                try {
                    super.write(ctx, modifiedPacket, promise);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            });
        }

        private PacketHandler(PlayerWrapper player) {
            this.player = player;
        }

        public static PacketHandler of(PlayerWrapper player) {
            return new PacketHandler(player);
        }
    }
}

