/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.packet;

import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.PacketWriter;
import io.github.pronze.lib.screaminglib.utils.math.Vector3Df;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import java.util.List;

public class SClientboundExplodePacket
extends AbstractPacket {
    private Vector3Df location;
    private float strength;
    private Vector3Df knockBackVelocity;
    private List<LocationHolder> blockLocations;

    @Override
    public void write(PacketWriter writer) {
        writer.writeVector(this.location);
        writer.writeFloat(this.strength);
        writer.writeSizedCollection(this.blockLocations, locationHolder -> writer.writeByteOffset(this.location, locationHolder.asVectorf()));
        writer.writeVector(this.knockBackVelocity);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SClientboundExplodePacket)) {
            return false;
        }
        SClientboundExplodePacket other = (SClientboundExplodePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Float.compare(this.strength(), other.strength()) != 0) {
            return false;
        }
        Vector3Df this$location = this.location();
        Vector3Df other$location = other.location();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        Vector3Df this$knockBackVelocity = this.knockBackVelocity();
        Vector3Df other$knockBackVelocity = other.knockBackVelocity();
        if (this$knockBackVelocity == null ? other$knockBackVelocity != null : !((Object)this$knockBackVelocity).equals(other$knockBackVelocity)) {
            return false;
        }
        List<LocationHolder> this$blockLocations = this.blockLocations();
        List<LocationHolder> other$blockLocations = other.blockLocations();
        return !(this$blockLocations == null ? other$blockLocations != null : !((Object)this$blockLocations).equals(other$blockLocations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SClientboundExplodePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Float.floatToIntBits(this.strength());
        Vector3Df $location = this.location();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        Vector3Df $knockBackVelocity = this.knockBackVelocity();
        result = result * 59 + ($knockBackVelocity == null ? 43 : ((Object)$knockBackVelocity).hashCode());
        List<LocationHolder> $blockLocations = this.blockLocations();
        result = result * 59 + ($blockLocations == null ? 43 : ((Object)$blockLocations).hashCode());
        return result;
    }

    public Vector3Df location() {
        return this.location;
    }

    public float strength() {
        return this.strength;
    }

    public Vector3Df knockBackVelocity() {
        return this.knockBackVelocity;
    }

    public List<LocationHolder> blockLocations() {
        return this.blockLocations;
    }

    public SClientboundExplodePacket location(Vector3Df location) {
        this.location = location;
        return this;
    }

    public SClientboundExplodePacket strength(float strength) {
        this.strength = strength;
        return this;
    }

    public SClientboundExplodePacket knockBackVelocity(Vector3Df knockBackVelocity) {
        this.knockBackVelocity = knockBackVelocity;
        return this;
    }

    public SClientboundExplodePacket blockLocations(List<LocationHolder> blockLocations) {
        this.blockLocations = blockLocations;
        return this;
    }

    public String toString() {
        return "SClientboundExplodePacket(location=" + this.location() + ", strength=" + this.strength() + ", knockBackVelocity=" + this.knockBackVelocity() + ", blockLocations=" + this.blockLocations() + ")";
    }
}

