/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.packet;

import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.PacketWriter;
import io.github.pronze.lib.screaminglib.utils.math.Vector3D;

public abstract class SClientboundMoveEntityPacket
extends AbstractPacket {
    private int entityId;
    private boolean onGround;

    @Override
    public void write(PacketWriter writer) {
        writer.writeVarInt(this.entityId);
        if (this instanceof Pos) {
            writer.writeMove(((Pos)this).delta);
        }
        if (this instanceof Rot) {
            writer.writeByteRotation(((Rot)this).yaw, ((Rot)this).pitch);
        }
        if (this instanceof PosRot) {
            writer.writeByteRotation(((PosRot)this).yaw, ((PosRot)this).pitch);
        }
        writer.writeBoolean(this.onGround);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SClientboundMoveEntityPacket)) {
            return false;
        }
        SClientboundMoveEntityPacket other = (SClientboundMoveEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.entityId() != other.entityId()) {
            return false;
        }
        return this.onGround() == other.onGround();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SClientboundMoveEntityPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.entityId();
        result = result * 59 + (this.onGround() ? 79 : 97);
        return result;
    }

    public int entityId() {
        return this.entityId;
    }

    public boolean onGround() {
        return this.onGround;
    }

    public SClientboundMoveEntityPacket entityId(int entityId) {
        this.entityId = entityId;
        return this;
    }

    public SClientboundMoveEntityPacket onGround(boolean onGround) {
        this.onGround = onGround;
        return this;
    }

    public String toString() {
        return "SClientboundMoveEntityPacket(entityId=" + this.entityId() + ", onGround=" + this.onGround() + ")";
    }

    public static class Pos
    extends SClientboundMoveEntityPacket {
        private Vector3D delta;

        @Override
        public Pos entityId(int entityId) {
            return (Pos)super.entityId(entityId);
        }

        @Override
        public Pos onGround(boolean onGround) {
            return (Pos)super.onGround(onGround);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pos)) {
                return false;
            }
            Pos other = (Pos)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Vector3D this$delta = this.delta();
            Vector3D other$delta = other.delta();
            return !(this$delta == null ? other$delta != null : !((Object)this$delta).equals(other$delta));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Pos;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Vector3D $delta = this.delta();
            result = result * 59 + ($delta == null ? 43 : ((Object)$delta).hashCode());
            return result;
        }

        public Vector3D delta() {
            return this.delta;
        }

        public Pos delta(Vector3D delta) {
            this.delta = delta;
            return this;
        }

        @Override
        public String toString() {
            return "SClientboundMoveEntityPacket.Pos(delta=" + this.delta() + ")";
        }
    }

    public static class Rot
    extends SClientboundMoveEntityPacket {
        private float yaw;
        private float pitch;

        @Override
        public Rot entityId(int entityId) {
            return (Rot)super.entityId(entityId);
        }

        @Override
        public Rot onGround(boolean onGround) {
            return (Rot)super.onGround(onGround);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Rot)) {
                return false;
            }
            Rot other = (Rot)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (Float.compare(this.yaw(), other.yaw()) != 0) {
                return false;
            }
            return Float.compare(this.pitch(), other.pitch()) == 0;
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Rot;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + Float.floatToIntBits(this.yaw());
            result = result * 59 + Float.floatToIntBits(this.pitch());
            return result;
        }

        public float yaw() {
            return this.yaw;
        }

        public float pitch() {
            return this.pitch;
        }

        public Rot yaw(float yaw) {
            this.yaw = yaw;
            return this;
        }

        public Rot pitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        @Override
        public String toString() {
            return "SClientboundMoveEntityPacket.Rot(yaw=" + this.yaw() + ", pitch=" + this.pitch() + ")";
        }
    }

    public static class PosRot
    extends Pos {
        private float yaw;
        private float pitch;

        @Override
        public PosRot entityId(int entityId) {
            return (PosRot)super.entityId(entityId);
        }

        @Override
        public PosRot onGround(boolean onGround) {
            return (PosRot)super.onGround(onGround);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PosRot)) {
                return false;
            }
            PosRot other = (PosRot)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (Float.compare(this.yaw(), other.yaw()) != 0) {
                return false;
            }
            return Float.compare(this.pitch(), other.pitch()) == 0;
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof PosRot;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + Float.floatToIntBits(this.yaw());
            result = result * 59 + Float.floatToIntBits(this.pitch());
            return result;
        }

        public float yaw() {
            return this.yaw;
        }

        public float pitch() {
            return this.pitch;
        }

        public PosRot yaw(float yaw) {
            this.yaw = yaw;
            return this;
        }

        public PosRot pitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        @Override
        public String toString() {
            return "SClientboundMoveEntityPacket.PosRot(yaw=" + this.yaw() + ", pitch=" + this.pitch() + ")";
        }
    }
}

