/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.packet;

import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.PacketWriter;
import io.github.pronze.lib.screaminglib.slot.EquipmentSlotHolder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SClientboundSetEquipmentPacket
extends AbstractPacket {
    private int entityId;
    private final Map<EquipmentSlotHolder, Item> slots = new HashMap<EquipmentSlotHolder, Item>();

    @Override
    public void write(PacketWriter writer) {
        writer.writeVarInt(this.entityId);
        Iterator<Map.Entry<EquipmentSlotHolder, Item>> iterator = this.slots.entrySet().iterator();
        boolean hasNext = iterator.hasNext();
        boolean first = false;
        while (hasNext) {
            Map.Entry<EquipmentSlotHolder, Item> next = iterator.next();
            hasNext = iterator.hasNext();
            if (writer.protocol() >= 732) {
                if (hasNext) {
                    writer.writeByte((byte)(writer.getEquipmentSlotId(next.getKey()) | 0x80));
                } else {
                    writer.writeByte((byte)writer.getEquipmentSlotId(next.getKey()));
                }
                writer.writeItem(next.getValue());
                continue;
            }
            if (!first) {
                if (writer.protocol() >= 49) {
                    writer.writeVarInt(writer.getEquipmentSlotId(next.getKey()));
                } else {
                    writer.writeShort(writer.getEquipmentSlotId(next.getKey()));
                }
                writer.writeItem(next.getValue());
                first = true;
                continue;
            }
            SClientboundSetEquipmentPacket append = new SClientboundSetEquipmentPacket();
            append.entityId(this.entityId);
            append.slots().put(next.getKey(), next.getValue());
            writer.append(append);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SClientboundSetEquipmentPacket)) {
            return false;
        }
        SClientboundSetEquipmentPacket other = (SClientboundSetEquipmentPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.entityId() != other.entityId()) {
            return false;
        }
        Map<EquipmentSlotHolder, Item> this$slots = this.slots();
        Map<EquipmentSlotHolder, Item> other$slots = other.slots();
        return !(this$slots == null ? other$slots != null : !((Object)this$slots).equals(other$slots));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SClientboundSetEquipmentPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.entityId();
        Map<EquipmentSlotHolder, Item> $slots = this.slots();
        result = result * 59 + ($slots == null ? 43 : ((Object)$slots).hashCode());
        return result;
    }

    public int entityId() {
        return this.entityId;
    }

    public Map<EquipmentSlotHolder, Item> slots() {
        return this.slots;
    }

    public SClientboundSetEquipmentPacket entityId(int entityId) {
        this.entityId = entityId;
        return this;
    }

    public String toString() {
        return "SClientboundSetEquipmentPacket(entityId=" + this.entityId() + ", slots=" + this.slots() + ")";
    }
}

