/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.packet;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.format.NamedTextColor;
import io.github.pronze.lib.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import io.github.pronze.lib.screaminglib.packet.AbstractPacket;
import io.github.pronze.lib.screaminglib.packet.PacketWriter;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import java.util.Collection;

public class SClientboundSetPlayerTeamPacket
extends AbstractPacket {
    private String teamKey;
    private Mode mode;
    private Component displayName;
    private boolean friendlyFire;
    private boolean seeInvisible;
    private TagVisibility tagVisibility;
    private CollisionRule collisionRule;
    private NamedTextColor teamColor;
    private Component teamPrefix;
    private Component teamSuffix;
    private Collection<String> entities;

    @Override
    public void write(PacketWriter writer) {
        writer.writeSizedString(this.teamKey);
        writer.writeByte((byte)this.mode.ordinal());
        if (this.mode == Mode.CREATE || this.mode == Mode.UPDATE) {
            if (writer.protocol() >= 390) {
                writer.writeComponent(this.displayName);
            } else {
                writer.writeSizedString(LegacyComponentSerializer.legacySection().serialize(this.displayName));
            }
            if (writer.protocol() < 352) {
                writer.writeSizedString(LegacyComponentSerializer.legacySection().serialize(this.teamPrefix));
                writer.writeSizedString(LegacyComponentSerializer.legacySection().serialize(this.teamSuffix));
            }
            writer.writeByte((byte)((this.friendlyFire ? 1 : 0) | (this.seeInvisible ? 2 : 0)));
            writer.writeSizedString(this.tagVisibility.enumName());
            if (writer.protocol() > 70) {
                writer.writeSizedString(this.collisionRule.enumName());
            }
            if (writer.protocol() < 352) {
                writer.writeByte((byte)AdventureHelper.NAMED_TEXT_COLOR_ID_MAP.get(this.teamColor).intValue());
            } else {
                writer.writeVarInt(AdventureHelper.NAMED_TEXT_COLOR_ID_MAP.get(this.teamColor));
            }
            if (writer.protocol() >= 375) {
                writer.writeComponent(this.teamPrefix);
                writer.writeComponent(this.teamSuffix);
            }
        }
        if (this.mode == Mode.CREATE || this.mode == Mode.ADD_ENTITY || this.mode == Mode.REMOVE_ENTITY) {
            writer.writeStringCollection(this.entities);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SClientboundSetPlayerTeamPacket)) {
            return false;
        }
        SClientboundSetPlayerTeamPacket other = (SClientboundSetPlayerTeamPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.friendlyFire() != other.friendlyFire()) {
            return false;
        }
        if (this.seeInvisible() != other.seeInvisible()) {
            return false;
        }
        String this$teamKey = this.teamKey();
        String other$teamKey = other.teamKey();
        if (this$teamKey == null ? other$teamKey != null : !this$teamKey.equals(other$teamKey)) {
            return false;
        }
        Mode this$mode = this.mode();
        Mode other$mode = other.mode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        Component this$displayName = this.displayName();
        Component other$displayName = other.displayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        TagVisibility this$tagVisibility = this.tagVisibility();
        TagVisibility other$tagVisibility = other.tagVisibility();
        if (this$tagVisibility == null ? other$tagVisibility != null : !((Object)((Object)this$tagVisibility)).equals((Object)other$tagVisibility)) {
            return false;
        }
        CollisionRule this$collisionRule = this.collisionRule();
        CollisionRule other$collisionRule = other.collisionRule();
        if (this$collisionRule == null ? other$collisionRule != null : !((Object)((Object)this$collisionRule)).equals((Object)other$collisionRule)) {
            return false;
        }
        NamedTextColor this$teamColor = this.teamColor();
        NamedTextColor other$teamColor = other.teamColor();
        if (this$teamColor == null ? other$teamColor != null : !this$teamColor.equals(other$teamColor)) {
            return false;
        }
        Component this$teamPrefix = this.teamPrefix();
        Component other$teamPrefix = other.teamPrefix();
        if (this$teamPrefix == null ? other$teamPrefix != null : !this$teamPrefix.equals(other$teamPrefix)) {
            return false;
        }
        Component this$teamSuffix = this.teamSuffix();
        Component other$teamSuffix = other.teamSuffix();
        if (this$teamSuffix == null ? other$teamSuffix != null : !this$teamSuffix.equals(other$teamSuffix)) {
            return false;
        }
        Collection<String> this$entities = this.entities();
        Collection<String> other$entities = other.entities();
        return !(this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SClientboundSetPlayerTeamPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.friendlyFire() ? 79 : 97);
        result = result * 59 + (this.seeInvisible() ? 79 : 97);
        String $teamKey = this.teamKey();
        result = result * 59 + ($teamKey == null ? 43 : $teamKey.hashCode());
        Mode $mode = this.mode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        Component $displayName = this.displayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        TagVisibility $tagVisibility = this.tagVisibility();
        result = result * 59 + ($tagVisibility == null ? 43 : ((Object)((Object)$tagVisibility)).hashCode());
        CollisionRule $collisionRule = this.collisionRule();
        result = result * 59 + ($collisionRule == null ? 43 : ((Object)((Object)$collisionRule)).hashCode());
        NamedTextColor $teamColor = this.teamColor();
        result = result * 59 + ($teamColor == null ? 43 : $teamColor.hashCode());
        Component $teamPrefix = this.teamPrefix();
        result = result * 59 + ($teamPrefix == null ? 43 : $teamPrefix.hashCode());
        Component $teamSuffix = this.teamSuffix();
        result = result * 59 + ($teamSuffix == null ? 43 : $teamSuffix.hashCode());
        Collection<String> $entities = this.entities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        return result;
    }

    public String teamKey() {
        return this.teamKey;
    }

    public Mode mode() {
        return this.mode;
    }

    public Component displayName() {
        return this.displayName;
    }

    public boolean friendlyFire() {
        return this.friendlyFire;
    }

    public boolean seeInvisible() {
        return this.seeInvisible;
    }

    public TagVisibility tagVisibility() {
        return this.tagVisibility;
    }

    public CollisionRule collisionRule() {
        return this.collisionRule;
    }

    public NamedTextColor teamColor() {
        return this.teamColor;
    }

    public Component teamPrefix() {
        return this.teamPrefix;
    }

    public Component teamSuffix() {
        return this.teamSuffix;
    }

    public Collection<String> entities() {
        return this.entities;
    }

    public SClientboundSetPlayerTeamPacket teamKey(String teamKey) {
        this.teamKey = teamKey;
        return this;
    }

    public SClientboundSetPlayerTeamPacket mode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public SClientboundSetPlayerTeamPacket displayName(Component displayName) {
        this.displayName = displayName;
        return this;
    }

    public SClientboundSetPlayerTeamPacket friendlyFire(boolean friendlyFire) {
        this.friendlyFire = friendlyFire;
        return this;
    }

    public SClientboundSetPlayerTeamPacket seeInvisible(boolean seeInvisible) {
        this.seeInvisible = seeInvisible;
        return this;
    }

    public SClientboundSetPlayerTeamPacket tagVisibility(TagVisibility tagVisibility) {
        this.tagVisibility = tagVisibility;
        return this;
    }

    public SClientboundSetPlayerTeamPacket collisionRule(CollisionRule collisionRule) {
        this.collisionRule = collisionRule;
        return this;
    }

    public SClientboundSetPlayerTeamPacket teamColor(NamedTextColor teamColor) {
        this.teamColor = teamColor;
        return this;
    }

    public SClientboundSetPlayerTeamPacket teamPrefix(Component teamPrefix) {
        this.teamPrefix = teamPrefix;
        return this;
    }

    public SClientboundSetPlayerTeamPacket teamSuffix(Component teamSuffix) {
        this.teamSuffix = teamSuffix;
        return this;
    }

    public SClientboundSetPlayerTeamPacket entities(Collection<String> entities) {
        this.entities = entities;
        return this;
    }

    public String toString() {
        return "SClientboundSetPlayerTeamPacket(teamKey=" + this.teamKey() + ", mode=" + this.mode() + ", displayName=" + this.displayName() + ", friendlyFire=" + this.friendlyFire() + ", seeInvisible=" + this.seeInvisible() + ", tagVisibility=" + this.tagVisibility() + ", collisionRule=" + this.collisionRule() + ", teamColor=" + this.teamColor() + ", teamPrefix=" + this.teamPrefix() + ", teamSuffix=" + this.teamSuffix() + ", entities=" + this.entities() + ")";
    }

    public static enum Mode {
        CREATE,
        REMOVE,
        UPDATE,
        ADD_ENTITY,
        REMOVE_ENTITY;

    }

    public static enum TagVisibility {
        ALWAYS("always"),
        HIDE_FOR_OTHER_TEAMS("hideForOtherTeams"),
        HIDE_FOR_OWN_TEAM("hideForOwnTeam"),
        NEVER("never");

        private final String enumName;

        private TagVisibility(String enumName) {
            this.enumName = enumName;
        }

        public String enumName() {
            return this.enumName;
        }
    }

    public static enum CollisionRule {
        ALWAYS("always"),
        PUSH_OTHER_TEAMS("pushOtherTeams"),
        PUSH_OWN_TEAM("pushOwnTeam"),
        NEVER("never");

        private final String enumName;

        private CollisionRule(String enumName) {
            this.enumName = enumName;
        }

        public String enumName() {
            return this.enumName;
        }
    }
}

