/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.packet.entity;

import io.github.pronze.lib.screaminglib.Server;
import io.github.pronze.lib.screaminglib.packet.MetadataItem;
import io.github.pronze.lib.screaminglib.packet.entity.FakeEntity;
import io.github.pronze.lib.screaminglib.packet.entity.FakeLivingEntity;
import io.github.pronze.lib.screaminglib.utils.math.Vector3Df;
import io.github.pronze.lib.screaminglib.world.LocationHolder;

public class FakeArmorStandEntity
extends FakeLivingEntity {
    private byte armorStandFlags = 0;
    private Vector3Df headRotation = new Vector3Df(0.0f, 0.0f, 0.0f);

    public FakeArmorStandEntity(LocationHolder location, int typeId) {
        super(location, typeId);
        this.setArmorStandFlags();
    }

    @Override
    public void setGravity(boolean gravity) {
        if (Server.isVersion(1, 10)) {
            this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.HAS_NO_GRAVITY), !gravity));
        } else {
            this.setArmorStandFlagsFromValue(2, gravity);
            this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.ARMOR_STAND_FLAGS), this.armorStandFlags));
        }
    }

    public void setArmorStandFlags() {
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.ARMOR_STAND_FLAGS), this.armorStandFlags));
    }

    public void setHeadRotation(Vector3Df value) {
        this.headRotation = value;
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.HEAD_ROTATION), value));
    }

    public void setBodyRotation(Vector3Df value) {
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.BODY_ROTATION), value));
    }

    public void setLeftArmRotation(Vector3Df value) {
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.LEFT_ARM_ROTATION), value));
    }

    public void setRightArmRotation(Vector3Df value) {
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.RIGHT_ARM_ROTATION), value));
    }

    public void setLeftLegRotation(Vector3Df value) {
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.LEFT_LEG_ROTATION), value));
    }

    public void setRightLegRotation(Vector3Df value) {
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.RIGHT_LEG_ROTATION), value));
    }

    public void setMarker(boolean marker) {
        this.setArmorStandFlagsFromValue(16, marker);
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.ARMOR_STAND_FLAGS), this.armorStandFlags));
    }

    public void setArms(boolean hasArms) {
        this.setArmorStandFlagsFromValue(4, hasArms);
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.ARMOR_STAND_FLAGS), this.armorStandFlags));
    }

    public void setBasePlate(boolean hasBasePlate) {
        this.setArmorStandFlagsFromValue(8, hasBasePlate);
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.ARMOR_STAND_FLAGS), this.armorStandFlags));
    }

    public void setSmall(boolean isSmall) {
        this.setArmorStandFlagsFromValue(1, isSmall);
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.ARMOR_STAND_FLAGS), this.armorStandFlags));
    }

    private void setArmorStandFlagsFromValue(int i, boolean flag) {
        this.armorStandFlags = flag ? (byte)(this.armorStandFlags | i) : (byte)(this.armorStandFlags & ~i);
    }

    public byte getArmorStandFlags() {
        return this.armorStandFlags;
    }

    public Vector3Df getHeadRotation() {
        return this.headRotation;
    }
}

