/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.particle;

import io.github.pronze.lib.screaminglib.particle.ParticleData;
import io.github.pronze.lib.screaminglib.particle.ParticleTypeHolder;
import io.github.pronze.lib.screaminglib.utils.math.Vector3D;
import org.jetbrains.annotations.Nullable;

public class ParticleHolder {
    private final ParticleTypeHolder particleType;
    private final int count;
    private final Vector3D offset;
    private final double particleData;
    private final boolean longDistance;
    @Nullable
    private final ParticleData specialData;

    public ParticleHolder(ParticleTypeHolder particleType) {
        this(particleType, 1, Vector3D.ZERO, 1.0, false, null);
    }

    public ParticleHolder(ParticleTypeHolder particleType, int count) {
        this(particleType, count, Vector3D.ZERO, 1.0, false, null);
    }

    public ParticleHolder(ParticleTypeHolder particleType, int count, Vector3D offset) {
        this(particleType, count, offset, 1.0, false, null);
    }

    public ParticleHolder(ParticleTypeHolder particleType, int count, Vector3D offset, double particleData) {
        this(particleType, count, offset, particleData, false, null);
    }

    public ParticleHolder(ParticleTypeHolder particleType, int count, Vector3D offset, double particleData, boolean longDistance) {
        this(particleType, count, offset, particleData, longDistance, null);
    }

    public ParticleTypeHolder particleType() {
        return this.particleType;
    }

    public int count() {
        return this.count;
    }

    public Vector3D offset() {
        return this.offset;
    }

    public double particleData() {
        return this.particleData;
    }

    public boolean longDistance() {
        return this.longDistance;
    }

    @Nullable
    public ParticleData specialData() {
        return this.specialData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParticleHolder)) {
            return false;
        }
        ParticleHolder other = (ParticleHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.count() != other.count()) {
            return false;
        }
        if (Double.compare(this.particleData(), other.particleData()) != 0) {
            return false;
        }
        if (this.longDistance() != other.longDistance()) {
            return false;
        }
        ParticleTypeHolder this$particleType = this.particleType();
        ParticleTypeHolder other$particleType = other.particleType();
        if (this$particleType == null ? other$particleType != null : !this$particleType.equals(other$particleType)) {
            return false;
        }
        Vector3D this$offset = this.offset();
        Vector3D other$offset = other.offset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        ParticleData this$specialData = this.specialData();
        ParticleData other$specialData = other.specialData();
        return !(this$specialData == null ? other$specialData != null : !this$specialData.equals(other$specialData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParticleHolder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.count();
        long $particleData = Double.doubleToLongBits(this.particleData());
        result = result * 59 + (int)($particleData >>> 32 ^ $particleData);
        result = result * 59 + (this.longDistance() ? 79 : 97);
        ParticleTypeHolder $particleType = this.particleType();
        result = result * 59 + ($particleType == null ? 43 : $particleType.hashCode());
        Vector3D $offset = this.offset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        ParticleData $specialData = this.specialData();
        result = result * 59 + ($specialData == null ? 43 : $specialData.hashCode());
        return result;
    }

    public String toString() {
        return "ParticleHolder(particleType=" + this.particleType() + ", count=" + this.count() + ", offset=" + this.offset() + ", particleData=" + this.particleData() + ", longDistance=" + this.longDistance() + ", specialData=" + this.specialData() + ")";
    }

    public ParticleHolder withParticleType(ParticleTypeHolder particleType) {
        return this.particleType == particleType ? this : new ParticleHolder(particleType, this.count, this.offset, this.particleData, this.longDistance, this.specialData);
    }

    public ParticleHolder withCount(int count) {
        return this.count == count ? this : new ParticleHolder(this.particleType, count, this.offset, this.particleData, this.longDistance, this.specialData);
    }

    public ParticleHolder withOffset(Vector3D offset) {
        return this.offset == offset ? this : new ParticleHolder(this.particleType, this.count, offset, this.particleData, this.longDistance, this.specialData);
    }

    public ParticleHolder withParticleData(double particleData) {
        return this.particleData == particleData ? this : new ParticleHolder(this.particleType, this.count, this.offset, particleData, this.longDistance, this.specialData);
    }

    public ParticleHolder withLongDistance(boolean longDistance) {
        return this.longDistance == longDistance ? this : new ParticleHolder(this.particleType, this.count, this.offset, this.particleData, longDistance, this.specialData);
    }

    public ParticleHolder withSpecialData(@Nullable ParticleData specialData) {
        return this.specialData == specialData ? this : new ParticleHolder(this.particleType, this.count, this.offset, this.particleData, this.longDistance, specialData);
    }

    public ParticleHolder(ParticleTypeHolder particleType, int count, Vector3D offset, double particleData, boolean longDistance, @Nullable ParticleData specialData) {
        this.particleType = particleType;
        this.count = count;
        this.offset = offset;
        this.particleData = particleData;
        this.longDistance = longDistance;
        this.specialData = specialData;
    }
}

