/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.particle;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.screaminglib.configurate.ParticleTypeHolderSerializer;
import io.github.pronze.lib.screaminglib.particle.ParticleTypeHolder;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.OfMethodAlternative;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostConstruct;
import io.github.pronze.lib.screaminglib.utils.mapper.AbstractTypeMapper;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@AbstractService
public abstract class ParticleTypeMapping
extends AbstractTypeMapper<ParticleTypeHolder> {
    private static ParticleTypeMapping particleTypeMapping;
    protected final BidirectionalConverter<ParticleTypeHolder> particleTypeConverter = BidirectionalConverter.build().registerP2W(ParticleTypeHolder.class, d -> d).registerP2W(ConfigurationNode.class, node -> {
        try {
            return ParticleTypeHolderSerializer.INSTANCE.deserialize((Type)((Object)ParticleTypeHolder.class), (ConfigurationNode)node);
        }
        catch (SerializationException ex) {
            ex.printStackTrace();
            return null;
        }
    });

    @ApiStatus.Internal
    public ParticleTypeMapping() {
        if (particleTypeMapping != null) {
            throw new UnsupportedOperationException("ParticleTypeMapping is already initialized!");
        }
        particleTypeMapping = this;
    }

    @OnPostConstruct
    public void mapMinecraftToBukkit() {
        this.mapAlias("AMBIENT_ENTITY_EFFECT", "SPELL_MOB_AMBIENT");
        this.mapAlias("ANGRY_VILLAGER", "VILLAGER_ANGRY");
        this.mapAlias("BLOCK", "BLOCK_CRACK");
        this.mapAlias("BLOCK", "BLOCK_DUST");
        this.mapAlias("BUBBLE", "WATER_BUBBLE");
        this.mapAlias("DRIPPING_LAVA", "DRIP_LAVA");
        this.mapAlias("DRIPPING_WATER", "DRIP_WATER");
        this.mapAlias("DUST", "REDSTONE");
        this.mapAlias("EFFECT", "SPELL");
        this.mapAlias("ELDER_GUARDIAN", "MOB_APPEARANCE");
        this.mapAlias("ENCHANT", "ENCHANTMENT_TABLE");
        this.mapAlias("ENCHANTED_HIT", "CRIT_MAGIC");
        this.mapAlias("ENTITY_EFFECT", "SPELL_MOB");
        this.mapAlias("EXPLOSION", "EXPLOSION_LARGE");
        this.mapAlias("EXPLOSION_EMITTER", "EXPLOSION_HUGE");
        this.mapAlias("FIREWORK", "FIREWORKS_SPARK");
        this.mapAlias("FISHING", "WATER_WAKE");
        this.mapAlias("HAPPY_VILLAGER", "VILLAGER_HAPPY");
        this.mapAlias("INSTANT_EFFECT", "SPELL_INSTANT");
        this.mapAlias("ITEM", "ITEM_CRACK");
        this.mapAlias("ITEM_SLIME", "SLIME");
        this.mapAlias("ITEM_SNOWBALL", "SNOWBALL");
        this.mapAlias("ITEM_SNOWBALL", "SNOW_SHOVEL");
        this.mapAlias("LARGE_SMOKE", "SMOKE_LARGE");
        this.mapAlias("MYCELIUM", "TOWN_AURA");
        this.mapAlias("POOF", "EXPLOSION_NORMAL");
        this.mapAlias("RAIN", "WATER_DROP");
        this.mapAlias("SMOKE", "SMOKE_NORMAL");
        this.mapAlias("SPLASH", "WATER_SPLASH");
        this.mapAlias("TOTEM_OF_UNDYING", "TOTEM");
        this.mapAlias("UNDERWATER", "SUSPENDED");
        this.mapAlias("UNDERWATER", "SUSPENDED_DEPTH");
        this.mapAlias("WITCH", "SPELL_WITCH");
        this.mapAlias("TAKE", "ITEM_TAKE");
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.PARTICLE_TYPE)
    @OfMethodAlternative(value=ParticleTypeHolder.class, methodName="ofOptional")
    public static Optional<ParticleTypeHolder> resolve(Object particle) {
        if (particleTypeMapping == null) {
            throw new UnsupportedOperationException("ParticleTypeMapping is not initialized yet.");
        }
        if (particle == null) {
            return Optional.empty();
        }
        return ParticleTypeMapping.particleTypeMapping.particleTypeConverter.convertOptional(particle).or(() -> particleTypeMapping.resolveFromMapping(particle));
    }

    @OfMethodAlternative(value=ParticleTypeHolder.class, methodName="all")
    public static List<ParticleTypeHolder> getValues() {
        if (particleTypeMapping == null) {
            throw new UnsupportedOperationException("ParticleTypeMapping is not initialized yet.");
        }
        return Collections.unmodifiableList(ParticleTypeMapping.particleTypeMapping.values);
    }
}

