/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.player;

import io.github.pronze.lib.screaminglib.player.FinalOfflinePlayerWrapper;
import io.github.pronze.lib.screaminglib.player.OfflinePlayerWrapper;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.player.SenderWrapper;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import io.github.pronze.lib.screaminglib.sender.MultiPlatformOfflinePlayer;
import io.github.pronze.lib.screaminglib.sender.Operator;
import io.github.pronze.lib.screaminglib.sender.permissions.Permission;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostConstruct;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;

@AbstractService
public abstract class PlayerMapper {
    protected final BidirectionalConverter<OfflinePlayerWrapper> offlinePlayerConverter = BidirectionalConverter.build();
    protected final BidirectionalConverter<PlayerWrapper> specialPlayerConverter = BidirectionalConverter.build();
    protected final BidirectionalConverter<PlayerWrapper.Hand> handConverter = BidirectionalConverter.build();
    private static PlayerMapper playerMapper;

    @ApiStatus.Internal
    public PlayerMapper() {
        if (playerMapper != null) {
            throw new UnsupportedOperationException("PlayerMapper is already initialized.");
        }
        playerMapper = this;
    }

    @OnPostConstruct
    public void postConstruct() {
        this.offlinePlayerConverter.registerP2W(UUID.class, uuid -> new FinalOfflinePlayerWrapper((UUID)uuid, null)).registerW2P(UUID.class, MultiPlatformOfflinePlayer::getUuid).registerP2W(OfflinePlayerWrapper.class, e -> e);
        this.handConverter.registerP2W(PlayerWrapper.Hand.class, e -> e);
    }

    public static <T> PlayerWrapper wrapPlayer(T player) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        try {
            CommandSenderWrapper sender = playerMapper.wrapSender0(player);
            if (sender instanceof PlayerWrapper) {
                return (PlayerWrapper)sender;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return PlayerMapper.playerMapper.specialPlayerConverter.convert(player);
    }

    public static <T> OfflinePlayerWrapper wrapOfflinePlayer(T player) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return PlayerMapper.playerMapper.offlinePlayerConverter.convert(player);
    }

    public static <T> CommandSenderWrapper wrapSender(T sender) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return playerMapper.wrapSender0(sender);
    }

    public static <T> PlayerWrapper.Hand wrapHand(T hand) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return PlayerMapper.playerMapper.handConverter.convert(hand);
    }

    public static <T> Optional<PlayerWrapper.Hand> resolveHand(T hand) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        if (hand == null) {
            return Optional.empty();
        }
        return PlayerMapper.playerMapper.handConverter.convertOptional(hand);
    }

    public static <T> T convertHand(PlayerWrapper.Hand hand, Class<T> type) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return PlayerMapper.playerMapper.handConverter.convert(hand, type);
    }

    public static <T> T convertOfflinePlayer(OfflinePlayerWrapper player, Class<T> type) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return PlayerMapper.playerMapper.offlinePlayerConverter.convert(player, type);
    }

    public static Optional<LocationHolder> getBedLocation(OfflinePlayerWrapper wrapper) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return playerMapper.getBedLocation0(wrapper);
    }

    public static Optional<PlayerWrapper> getPlayer(String name) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return playerMapper.getPlayer0(name);
    }

    public abstract Optional<PlayerWrapper> getPlayer0(String var1);

    public static Optional<PlayerWrapper> getPlayer(UUID uuid) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return playerMapper.getPlayer0(uuid);
    }

    public abstract Optional<PlayerWrapper> getPlayer0(UUID var1);

    public static Optional<PlayerWrapper> getPlayerExact(String name) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return playerMapper.getPlayerExact0(name);
    }

    public static SenderWrapper getConsoleSender() {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return playerMapper.getConsoleSender0();
    }

    public static boolean hasPermission(CommandSenderWrapper wrapper, Permission permission) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return playerMapper.hasPermission0(wrapper, permission);
    }

    public static boolean isPermissionSet(CommandSenderWrapper wrapper, Permission permission) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return playerMapper.isPermissionSet0(wrapper, permission);
    }

    public static boolean isOp(Operator wrapper) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return playerMapper.isOp0(wrapper);
    }

    public static void setOp(Operator wrapper, boolean op) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        playerMapper.setOp0(wrapper, op);
    }

    public static long getFirstPlayed(OfflinePlayerWrapper wrapper) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return playerMapper.getFirstPlayed0(wrapper);
    }

    public static long getLastPlayed(OfflinePlayerWrapper wrapper) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return playerMapper.getLastPlayed0(wrapper);
    }

    public static boolean isBanned(OfflinePlayerWrapper wrapper) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return playerMapper.isBanned0(wrapper);
    }

    public static boolean isWhitelisted(OfflinePlayerWrapper wrapper) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return playerMapper.isWhitelisted0(wrapper);
    }

    public static boolean isOnline(OfflinePlayerWrapper wrapper) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return playerMapper.isOnline0(wrapper);
    }

    public static void setWhitelisted(OfflinePlayerWrapper wrapper, boolean whitelisted) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        playerMapper.setWhitelisted0(wrapper, whitelisted);
    }

    public static OfflinePlayerWrapper getOfflinePlayer(UUID uuid) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return playerMapper.getOfflinePlayer0(uuid);
    }

    @Deprecated
    public static Optional<OfflinePlayerWrapper> getOfflinePlayer(String name) {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return playerMapper.getOfflinePlayer0(name);
    }

    public static BidirectionalConverter<PlayerWrapper> UNSAFE_getPlayerConverter() {
        if (playerMapper == null) {
            throw new UnsupportedOperationException("PlayerMapper isn't initialized yet.");
        }
        return PlayerMapper.playerMapper.specialPlayerConverter;
    }

    protected abstract <T> CommandSenderWrapper wrapSender0(T var1);

    public abstract SenderWrapper getConsoleSender0();

    public abstract Optional<LocationHolder> getBedLocation0(OfflinePlayerWrapper var1);

    public abstract boolean hasPermission0(CommandSenderWrapper var1, Permission var2);

    public abstract boolean isPermissionSet0(CommandSenderWrapper var1, Permission var2);

    public abstract boolean isOp0(Operator var1);

    public abstract void setOp0(Operator var1, boolean var2);

    public abstract long getFirstPlayed0(OfflinePlayerWrapper var1);

    public abstract long getLastPlayed0(OfflinePlayerWrapper var1);

    public abstract boolean isBanned0(OfflinePlayerWrapper var1);

    public abstract boolean isWhitelisted0(OfflinePlayerWrapper var1);

    public abstract boolean isOnline0(OfflinePlayerWrapper var1);

    public abstract void setWhitelisted0(OfflinePlayerWrapper var1, boolean var2);

    public abstract OfflinePlayerWrapper getOfflinePlayer0(UUID var1);

    public abstract Optional<OfflinePlayerWrapper> getOfflinePlayer0(String var1);

    public abstract Optional<PlayerWrapper> getPlayerExact0(String var1);
}

