/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.player.gamemode;

import io.github.pronze.lib.screaminglib.player.gamemode.GameModeMapping;
import io.github.pronze.lib.screaminglib.utils.ComparableWrapper;
import io.github.pronze.lib.screaminglib.utils.RawValueHolder;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import java.util.List;
import java.util.Optional;

public interface GameModeHolder
extends ComparableWrapper,
RawValueHolder {
    @Deprecated(forRemoval=true)
    default public String getPlatformName() {
        return this.platformName();
    }

    public String platformName();

    public int id();

    @Deprecated(forRemoval=true)
    default public int getId() {
        return this.id();
    }

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.GAME_MODE)
    public boolean is(Object var1);

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.GAME_MODE)
    public boolean is(Object ... var1);

    @CustomAutocompletion(value=CustomAutocompletion.Type.GAME_MODE)
    public static GameModeHolder of(Object gameMode) {
        return GameModeHolder.ofOptional(gameMode).orElseThrow();
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.GAME_MODE)
    public static Optional<GameModeHolder> ofOptional(Object gameMode) {
        if (gameMode instanceof GameModeHolder) {
            return Optional.of((GameModeHolder)gameMode);
        }
        return GameModeMapping.resolve(gameMode);
    }

    public static List<GameModeHolder> all() {
        return GameModeMapping.getValues();
    }
}

