/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.plugin;

import io.github.pronze.lib.screaminglib.plugin.PluginKey;
import io.github.pronze.lib.screaminglib.plugin.PluginManager;
import io.github.pronze.lib.screaminglib.utils.Wrapper;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public class PluginDescription
implements Wrapper {
    private final PluginKey pluginKey;
    private final String name;
    private final String version;
    private final String description;
    private final List<String> authors;
    private final List<String> dependencies;
    private final List<String> softDependencies;
    private final Path dataFolder;

    public Optional<Object> getInstance() {
        return PluginManager.getPlatformClass(this.pluginKey);
    }

    public boolean isEnabled() {
        return PluginManager.isEnabled(this.pluginKey);
    }

    @Override
    public <T> T as(Class<T> type) {
        Optional<Object> instance = PluginManager.getPlatformClass(this.pluginKey);
        if (instance.isPresent() && type.isInstance(instance.get())) {
            return (T)instance.get();
        }
        throw new UnsupportedOperationException("Can't convert instance to this type!");
    }

    public PluginDescription(PluginKey pluginKey, String name, String version, String description, List<String> authors, List<String> dependencies, List<String> softDependencies, Path dataFolder) {
        this.pluginKey = pluginKey;
        this.name = name;
        this.version = version;
        this.description = description;
        this.authors = authors;
        this.dependencies = dependencies;
        this.softDependencies = softDependencies;
        this.dataFolder = dataFolder;
    }

    public PluginKey getPluginKey() {
        return this.pluginKey;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public List<String> getSoftDependencies() {
        return this.softDependencies;
    }

    public Path getDataFolder() {
        return this.dataFolder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginDescription)) {
            return false;
        }
        PluginDescription other = (PluginDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PluginKey this$pluginKey = this.getPluginKey();
        PluginKey other$pluginKey = other.getPluginKey();
        if (this$pluginKey == null ? other$pluginKey != null : !this$pluginKey.equals(other$pluginKey)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$authors = this.getAuthors();
        List<String> other$authors = other.getAuthors();
        if (this$authors == null ? other$authors != null : !((Object)this$authors).equals(other$authors)) {
            return false;
        }
        List<String> this$dependencies = this.getDependencies();
        List<String> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        List<String> this$softDependencies = this.getSoftDependencies();
        List<String> other$softDependencies = other.getSoftDependencies();
        if (this$softDependencies == null ? other$softDependencies != null : !((Object)this$softDependencies).equals(other$softDependencies)) {
            return false;
        }
        Path this$dataFolder = this.getDataFolder();
        Path other$dataFolder = other.getDataFolder();
        return !(this$dataFolder == null ? other$dataFolder != null : !((Object)this$dataFolder).equals(other$dataFolder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PluginDescription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PluginKey $pluginKey = this.getPluginKey();
        result = result * 59 + ($pluginKey == null ? 43 : $pluginKey.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $authors = this.getAuthors();
        result = result * 59 + ($authors == null ? 43 : ((Object)$authors).hashCode());
        List<String> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        List<String> $softDependencies = this.getSoftDependencies();
        result = result * 59 + ($softDependencies == null ? 43 : ((Object)$softDependencies).hashCode());
        Path $dataFolder = this.getDataFolder();
        result = result * 59 + ($dataFolder == null ? 43 : ((Object)$dataFolder).hashCode());
        return result;
    }

    public String toString() {
        return "PluginDescription(pluginKey=" + this.getPluginKey() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", authors=" + this.getAuthors() + ", dependencies=" + this.getDependencies() + ", softDependencies=" + this.getSoftDependencies() + ", dataFolder=" + this.getDataFolder() + ")";
    }
}

