/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.plugin;

import io.github.pronze.lib.screaminglib.utils.annotations.internal.InternalOnly;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ServiceManager {
    private static final List<Object> services = new LinkedList<Object>();

    @InternalOnly
    public static void putService(Object service) {
        if (!services.contains(service)) {
            services.add(service);
        }
    }

    public static <T> T get(Class<T> serviceType) {
        return (T)services.stream().filter(o -> serviceType.isAssignableFrom(o.getClass())).findFirst().orElseThrow();
    }

    public static <T> Optional<T> getOptional(Class<T> serviceType) {
        return services.stream().filter(o -> serviceType.isAssignableFrom(o.getClass())).findFirst();
    }

    public static <T> List<T> getAll(Class<T> serviceType) {
        return services.stream().filter(o -> serviceType.isAssignableFrom(o.getClass())).collect(Collectors.toList());
    }
}

