/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.sender;

import io.github.pronze.lib.kyori.adventure.audience.ForwardingAudience;
import io.github.pronze.lib.kyori.adventure.title.Title;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import io.github.pronze.lib.screaminglib.sender.SenderMessage;
import io.github.pronze.lib.screaminglib.sender.TitleableSenderMessage;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface SForwardingAudience
extends ForwardingAudience {
    @ApiStatus.OverrideOnly
    @NotNull
    public Iterable<CommandSenderWrapper> audiences();

    default public void sendMessage(String message) {
        this.sendMessage(AdventureHelper.toComponent(message));
    }

    default public void sendMessage(SenderMessage senderMessage) {
        this.audiences().forEach(senderWrapper -> this.sendMessage(senderMessage.asComponent((CommandSenderWrapper)senderWrapper)));
    }

    default public void sendActionBar(SenderMessage senderMessage) {
        this.audiences().forEach(senderWrapper -> this.sendActionBar(senderMessage.asComponent((CommandSenderWrapper)senderWrapper)));
    }

    default public void sendPlayerListHeader(SenderMessage senderMessage) {
        this.audiences().forEach(senderWrapper -> this.sendPlayerListHeader(senderMessage.asComponent((CommandSenderWrapper)senderWrapper)));
    }

    default public void sendPlayerListFooter(SenderMessage senderMessage) {
        this.audiences().forEach(senderWrapper -> this.sendPlayerListFooter(senderMessage.asComponent((CommandSenderWrapper)senderWrapper)));
    }

    default public void sendPlayerListHeaderAndFooter(SenderMessage header, SenderMessage footer) {
        this.audiences().forEach(senderWrapper -> this.sendPlayerListHeaderAndFooter(header.asComponent((CommandSenderWrapper)senderWrapper), footer.asComponent((CommandSenderWrapper)senderWrapper)));
    }

    default public void showTitle(TitleableSenderMessage title) {
        this.audiences().forEach(senderWrapper -> this.showTitle(title.asTitle((CommandSenderWrapper)senderWrapper)));
    }

    default public void showTitle(TitleableSenderMessage title, Title.Times times) {
        this.audiences().forEach(senderWrapper -> this.showTitle(title.asTitle((CommandSenderWrapper)senderWrapper, times)));
    }
}

