/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.slot;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.screaminglib.configurate.EquipmentSlotHolderSerializer;
import io.github.pronze.lib.screaminglib.slot.EquipmentSlotHolder;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.OfMethodAlternative;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostConstruct;
import io.github.pronze.lib.screaminglib.utils.mapper.AbstractTypeMapper;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@AbstractService
public abstract class EquipmentSlotMapping
extends AbstractTypeMapper<EquipmentSlotHolder> {
    private static EquipmentSlotMapping equipmentSlotMapping;
    protected final BidirectionalConverter<EquipmentSlotHolder> equipmentSlotConverter = BidirectionalConverter.build().registerP2W(EquipmentSlotHolder.class, e -> e).registerP2W(ConfigurationNode.class, node -> {
        try {
            return EquipmentSlotHolderSerializer.INSTANCE.deserialize((Type)((Object)EquipmentSlotHolder.class), (ConfigurationNode)node);
        }
        catch (SerializationException ex) {
            ex.printStackTrace();
            return null;
        }
    });

    @ApiStatus.Internal
    public EquipmentSlotMapping() {
        if (equipmentSlotMapping != null) {
            throw new UnsupportedOperationException("EquipmentSlotMapping is already initialized.");
        }
        equipmentSlotMapping = this;
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.EQUIPMENT_SLOT)
    @OfMethodAlternative(value=EquipmentSlotHolder.class, methodName="ofOptional")
    public static Optional<EquipmentSlotHolder> resolve(Object slot) {
        if (equipmentSlotMapping == null) {
            throw new UnsupportedOperationException("EquipmentSlotMapping is not initialized yet.");
        }
        if (slot == null) {
            return Optional.empty();
        }
        return EquipmentSlotMapping.equipmentSlotMapping.equipmentSlotConverter.convertOptional(slot).or(() -> equipmentSlotMapping.resolveFromMapping(slot));
    }

    @OfMethodAlternative(value=EquipmentSlotHolder.class, methodName="all")
    public static List<EquipmentSlotHolder> getValues() {
        if (equipmentSlotMapping == null) {
            throw new UnsupportedOperationException("EquipmentSlotMapping is not initialized yet.");
        }
        return Collections.unmodifiableList(EquipmentSlotMapping.equipmentSlotMapping.values);
    }

    @OnPostConstruct
    public void legacyMapping() {
        this.mapAlias("MAIN_HAND", "HAND");
        this.mapAlias("OFF_HAND", "OFF_HAND");
        this.mapAlias("BOOTS", "FEET");
        this.mapAlias("LEGGINGS", "LEGS");
        this.mapAlias("CHESTPLATE", "CHEST");
        this.mapAlias("HELMET", "HEAD");
    }
}

