/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.tasker;

import io.github.pronze.lib.screaminglib.tasker.TaskBuilderImpl;
import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.lib.screaminglib.tasker.initializer.AbstractTaskInitializer;
import io.github.pronze.lib.screaminglib.tasker.task.TaskBase;
import io.github.pronze.lib.screaminglib.tasker.task.TaskState;
import io.github.pronze.lib.screaminglib.tasker.task.TaskerTask;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

class TaskerImpl
implements Tasker {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Map<Integer, TaskerTask> runningTasks = new ConcurrentHashMap<Integer, TaskerTask>();
    protected final AbstractTaskInitializer initializer;
    protected static TaskerImpl instance;

    @Override
    Tasker.TaskBuilder build(Runnable runnable) {
        return new TaskBuilderImpl(runnable, this.initializer, this.counter.incrementAndGet());
    }

    @Override
    Tasker.TaskBuilder build(Function<TaskBase, Runnable> taskBase) {
        int id = this.counter.incrementAndGet();
        return new TaskBuilderImpl(taskBase.apply(() -> {
            TaskerTask task = this.runningTasks.get(id);
            if (task != null) {
                task.cancel();
            }
        }), this.initializer, id);
    }

    @Override
    public Map<Integer, TaskerTask> getRunningTasks() {
        return Map.copyOf(this.runningTasks);
    }

    @Override
    public void cancelAll() {
        Collection<TaskerTask> tasks = this.getRunningTasks().values();
        tasks.forEach(this::cancel);
    }

    @Override
    public void cancel(TaskerTask taskerTask) {
        TaskerTask task = this.runningTasks.get(taskerTask.getId());
        if (task == null) {
            return;
        }
        try {
            this.initializer.cancel(taskerTask);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Exception while cancelling task " + taskerTask.getId() + "!", e);
        }
        this.runningTasks.remove(task.getId());
    }

    @Override
    public boolean register(@NotNull TaskerTask taskerTask) {
        Integer id = taskerTask.getId();
        if (this.runningTasks.containsKey(id)) {
            return false;
        }
        this.runningTasks.putIfAbsent(id, taskerTask);
        return true;
    }

    @Override
    public TaskState getState(TaskerTask taskerTask) {
        return this.initializer.getState(taskerTask);
    }

    public TaskerImpl(AbstractTaskInitializer initializer) {
        this.initializer = initializer;
    }
}

